/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;

public class StaticVerifier
extends ClassCodeVisitorSupport {
    private boolean inSpecialConstructorCall;
    private boolean inPropertyExpression;
    private boolean inClosure;
    private MethodNode currentMethod;
    private SourceUnit source;

    public void visitClass(ClassNode node, SourceUnit source) {
        this.source = source;
        super.visitClass(node);
    }

    public void visitVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null && v instanceof DynamicVariable && (!this.inPropertyExpression || this.inSpecialConstructorCall)) {
            this.addStaticVariableError(ve);
        }
    }

    public void visitClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        super.visitClosureExpression(ce);
        this.inClosure = oldInClosure;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression cce) {
        boolean oldIsSpecialConstructorCall = this.inSpecialConstructorCall;
        this.inSpecialConstructorCall = cce.isSpecialCall();
        super.visitConstructorCallExpression(cce);
        this.inSpecialConstructorCall = oldIsSpecialConstructorCall;
    }

    public void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        MethodNode oldCurrentMethod = this.currentMethod;
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = oldCurrentMethod;
    }

    public void visitMethodCallExpression(MethodCallExpression mce) {
        this.checkSuperAccess(mce, mce.getObjectExpression());
        super.visitMethodCallExpression(mce);
    }

    public void visitPropertyExpression(PropertyExpression pe) {
        boolean oldInPropertyExpression = this.inPropertyExpression;
        this.inPropertyExpression = true;
        this.checkSuperAccess(pe, pe.getObjectExpression());
        this.inPropertyExpression = oldInPropertyExpression;
        if (!this.inSpecialConstructorCall) {
            this.checkStaticScope(pe);
        }
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private void checkSuperAccess(Expression expr, Expression object) {
        VariableExpression ve;
        boolean isExplicitSuper;
        if (object instanceof VariableExpression && (isExplicitSuper = (ve = (VariableExpression)object).getName().equals("super")) && this.currentMethod != null && this.currentMethod.isStatic()) {
            this.addError("'super' cannot be used in a static context, use the explicit class instead.", expr);
        }
    }

    private void checkStaticScope(PropertyExpression pe) {
        if (this.inClosure) {
            return;
        }
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof PropertyExpression) continue;
            if (it instanceof VariableExpression) {
                this.addStaticVariableError((VariableExpression)it);
            }
            return;
        }
    }

    private void addStaticVariableError(VariableExpression ve) {
        FieldNode fieldNode;
        if (!(this.inSpecialConstructorCall || !this.inClosure && ve.isInStaticContext())) {
            return;
        }
        if (ve.isThisExpression() || ve.isSuperExpression()) {
            return;
        }
        Variable v = ve.getAccessedVariable();
        if (this.currentMethod != null && this.currentMethod.isStatic() && (fieldNode = this.currentMethod.getDeclaringClass().getField(ve.getName())) != null && fieldNode.isStatic()) {
            return;
        }
        if (v != null && !(v instanceof DynamicVariable) && v.isInStaticContext()) {
            return;
        }
        this.addError("Apparent variable '" + ve.getName() + "' was found in a static scope but doesn't refer" + " to a local variable, static field or class. Possible causes:\n" + "You attempted to reference a variable in the binding or an instance variable from a static context.\n" + "You misspelled a classname or statically imported field. Please check the spelling.\n" + "You attempted to use a method '" + ve.getName() + "' but left out brackets in a place not allowed by the grammar.", ve);
    }
}

