/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoClone;
import groovy.transform.AutoCloneStyle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class AutoCloneASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = AutoClone.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode CLONEABLE_TYPE = ClassHelper.make(Cloneable.class);
    private static final ClassNode BAOS_TYPE = ClassHelper.make(ByteArrayOutputStream.class);
    private static final ClassNode BAIS_TYPE = ClassHelper.make(ByteArrayInputStream.class);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            cNode.addInterface(CLONEABLE_TYPE);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            AutoCloneStyle style = this.getStyle(anno, "style");
            List<String> excludes = this.tokenize((String)this.getMemberValue(anno, "excludes"));
            List<FieldNode> list = AbstractASTTransformUtil.getInstancePropertyFields(cNode);
            if (includeFields) {
                list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
            }
            if (style == null) {
                style = AutoCloneStyle.CLONE;
            }
            switch (style) {
                case COPY_CONSTRUCTOR: {
                    this.createCloneCopyConstructor(cNode, list, excludes);
                    break;
                }
                case SERIALIZATION: {
                    this.createCloneSerialization(cNode, list, excludes);
                    break;
                }
                case CLONE: {
                    this.createClone(cNode, list, excludes);
                }
            }
        }
    }

    private void createCloneSerialization(ClassNode cNode, List<FieldNode> list, List<String> excludes) {
        BlockStatement body = new BlockStatement();
        VariableExpression baos = new VariableExpression("baos");
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)baos, ASSIGN, (Expression)new ConstructorCallExpression(BAOS_TYPE, MethodCallExpression.NO_ARGUMENTS))));
        BlockStatement writeClosureCode = new BlockStatement();
        VariableExpression it = new VariableExpression("it");
        writeClosureCode.addStatement(new ExpressionStatement(new MethodCallExpression((Expression)it, "writeObject", (Expression)VariableExpression.THIS_EXPRESSION)));
        ClosureExpression writeClosure = new ClosureExpression(new Parameter[0], writeClosureCode);
        writeClosure.setVariableScope(new VariableScope());
        body.addStatement(new ExpressionStatement(new MethodCallExpression((Expression)baos, "withObjectOutputStream", (Expression)new ArgumentListExpression(writeClosure))));
        VariableExpression bais = new VariableExpression("bais");
        ConstructorCallExpression bytes = new ConstructorCallExpression(BAIS_TYPE, new TupleExpression(new MethodCallExpression((Expression)baos, "toByteArray", MethodCallExpression.NO_ARGUMENTS)));
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)bais, ASSIGN, (Expression)bytes)));
        BlockStatement readClosureCode = new BlockStatement();
        readClosureCode.addStatement(new ExpressionStatement(new MethodCallExpression((Expression)it, "readObject", MethodCallExpression.NO_ARGUMENTS)));
        ClosureExpression readClosure = new ClosureExpression(new Parameter[0], readClosureCode);
        readClosure.setVariableScope(new VariableScope());
        MethodCallExpression klass = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "getClass", MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression classLoader = new MethodCallExpression((Expression)klass, "getClassLoader", MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression result = new MethodCallExpression((Expression)bais, "withObjectInputStream", (Expression)new ArgumentListExpression(classLoader, readClosure));
        body.addStatement(new ReturnStatement(result));
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, new Parameter[0], exceptions, body);
    }

    private void createCloneCopyConstructor(ClassNode cNode, List<FieldNode> list, List<String> excludes) {
        boolean hasParent;
        BlockStatement initBody = new BlockStatement();
        if (cNode.getDeclaredConstructors().size() == 0) {
            initBody.addStatement(new EmptyStatement());
            cNode.addConstructor(1, new Parameter[0], ClassNode.EMPTY_ARRAY, initBody);
            initBody = new BlockStatement();
        }
        Parameter initParam = new Parameter(cNode, "other");
        VariableExpression other = new VariableExpression(initParam);
        boolean bl = hasParent = cNode.getSuperClass() != ClassHelper.OBJECT_TYPE;
        if (hasParent) {
            initBody.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, other)));
        }
        for (FieldNode fieldNode : list) {
            String name = fieldNode.getName();
            if (excludes.contains(name)) continue;
            PropertyExpression direct = new PropertyExpression((Expression)other, name);
            MethodCallExpression cloned = new MethodCallExpression((Expression)direct, "clone", MethodCallExpression.NO_ARGUMENTS);
            PropertyExpression to = new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, name);
            Statement assignCloned = AbstractASTTransformUtil.assignStatement(to, cloned);
            Statement assignDirect = AbstractASTTransformUtil.assignStatement(to, direct);
            initBody.addStatement(new IfStatement(AbstractASTTransformUtil.isInstanceOf(direct, CLONEABLE_TYPE), assignCloned, assignDirect));
        }
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addConstructor(4, new Parameter[]{initParam}, ClassNode.EMPTY_ARRAY, initBody);
        BlockStatement cloneBody = new BlockStatement();
        cloneBody.addStatement(new ExpressionStatement(new ConstructorCallExpression(cNode, new ArgumentListExpression(VariableExpression.THIS_EXPRESSION))));
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, new Parameter[0], exceptions, cloneBody);
    }

    private void createClone(ClassNode cNode, List<FieldNode> list, List<String> excludes) {
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        MethodCallExpression clone = new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "clone", MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)clone)));
        for (FieldNode fieldNode : list) {
            if (excludes.contains(fieldNode.getName())) continue;
            VariableExpression fieldExpr = new VariableExpression(fieldNode);
            MethodCallExpression from = new MethodCallExpression((Expression)fieldExpr, "clone", MethodCallExpression.NO_ARGUMENTS);
            PropertyExpression to = new PropertyExpression((Expression)result, fieldNode.getName());
            Statement doClone = AbstractASTTransformUtil.assignStatement(to, from);
            EmptyStatement doNothing = new EmptyStatement();
            body.addStatement(new IfStatement(AbstractASTTransformUtil.isInstanceOf(fieldExpr, CLONEABLE_TYPE), doClone, doNothing));
        }
        body.addStatement(new ReturnStatement(result));
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(CloneNotSupportedException.class)};
        cNode.addMethod("clone", 1, ClassHelper.OBJECT_TYPE, new Parameter[0], exceptions, body);
    }

    private AutoCloneStyle getStyle(AnnotationNode node, String name) {
        ClassExpression ce;
        PropertyExpression prop;
        Expression oe;
        Expression member = node.getMember(name);
        if (member != null && member instanceof PropertyExpression && (oe = (prop = (PropertyExpression)member).getObjectExpression()) instanceof ClassExpression && (ce = (ClassExpression)oe).getType().getTypeClass() == AutoCloneStyle.class) {
            return AutoCloneStyle.valueOf(prop.getPropertyAsString());
        }
        return null;
    }
}

