/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.telephony.SmsManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import org.chorem.android.saymytexts.SMS;
import org.chorem.android.saymytexts.SayMyTextService;

public class SayNextActionBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "SayNextActionBroadcastReceiver";
    public static final String ACTION_SAY_NEXT_ACTION = "org.chorem.android.saymytexts.SAY_NEXT_ACTION";
    public static final String INTENT_EXTRA_SMS = "sms";
    public static final String INTENT_EXTRA_MESSAGE = "message";
    public static final String INTENT_EXTRA_ATTEMPT_NUMBER = "attemptNumber";
    public static final String INTENT_EXTRA_FALLBACK_ACTION = "fallbackAction";

    public void onReceive(final Context context, final Intent intent) {
        Log.d((String)TAG, (String)"next action ?");
        final SMS sms = (SMS)intent.getSerializableExtra(INTENT_EXTRA_SMS);
        if (sms != null) {
            SpeechRecognizer speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
            speechRecognizer.setRecognitionListener(new RecognitionListener(){
                private ToneGenerator tg = new ToneGenerator(0, 100);

                public void onReadyForSpeech(Bundle params) {
                }

                public void onBeginningOfSpeech() {
                }

                public void onRmsChanged(float rmsdB) {
                }

                public void onBufferReceived(byte[] buffer) {
                }

                public void onEndOfSpeech() {
                }

                public void onError(int error) {
                    Log.d((String)SayNextActionBroadcastReceiver.TAG, (String)("onError " + error));
                    this.tg.startTone(26);
                    SayNextActionBroadcastReceiver.this.reaskAction(context, intent, sms);
                }

                public void onResults(Bundle data) {
                    ArrayList results = data.getStringArrayList("results_recognition");
                    Log.d((String)SayNextActionBroadcastReceiver.TAG, (String)("results " + results));
                    if (results != null) {
                        if (results.contains(context.getString(2131034148))) {
                            try {
                                Intent callIntent = new Intent("android.intent.action.CALL");
                                callIntent.setFlags(0x10000000);
                                callIntent.setData(Uri.parse((String)("tel:" + sms.getSenderNumber())));
                                context.startActivity(callIntent);
                            }
                            catch (ActivityNotFoundException activityException) {
                                Log.e((String)SayNextActionBroadcastReceiver.TAG, (String)"Calling a Phone Number failed", (Throwable)activityException);
                                this.tg.startTone(26);
                                SayNextActionBroadcastReceiver.this.readNext(context);
                            }
                        } else if (results.contains(context.getString(2131034149)) || results.contains(context.getString(2131034152))) {
                            Log.d((String)SayNextActionBroadcastReceiver.TAG, (String)"R\u00e9pondre ou corriger");
                            Intent serviceIntent = new Intent(context, SayMyTextService.class);
                            serviceIntent.setAction("org.chorem.android.saymytexts.DICTATE_SMS");
                            serviceIntent.putExtra(SayNextActionBroadcastReceiver.INTENT_EXTRA_SMS, (Serializable)sms);
                            context.startService(serviceIntent);
                        } else if (results.contains(context.getString(2131034151))) {
                            String message = intent.getStringExtra(SayNextActionBroadcastReceiver.INTENT_EXTRA_MESSAGE);
                            SmsManager smsManager = SmsManager.getDefault();
                            smsManager.sendTextMessage(sms.getSenderNumber(), null, message, null, null);
                            this.tg.startTone(25);
                            SayNextActionBroadcastReceiver.this.readNext(context);
                        } else if (results.contains(context.getString(2131034150)) || results.contains(context.getString(2131034153))) {
                            Log.d((String)SayNextActionBroadcastReceiver.TAG, (String)"Quitter");
                            this.tg.startTone(25);
                            SayNextActionBroadcastReceiver.this.readNext(context);
                        } else {
                            this.tg.startTone(26);
                            SayNextActionBroadcastReceiver.this.reaskAction(context, intent, sms);
                        }
                    } else {
                        this.tg.startTone(26);
                        SayNextActionBroadcastReceiver.this.reaskAction(context, intent, sms);
                    }
                }

                public void onPartialResults(Bundle partialResults) {
                }

                public void onEvent(int eventType, Bundle params) {
                }
            });
            Intent recognizeIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
            recognizeIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
            speechRecognizer.startListening(recognizeIntent);
        }
    }

    protected void reaskAction(Context context, Intent intent, SMS sms) {
        int attemptNumber = intent.getIntExtra(INTENT_EXTRA_ATTEMPT_NUMBER, 1);
        String fallbackAction = intent.getStringExtra(INTENT_EXTRA_FALLBACK_ACTION);
        String dictatedMessage = intent.getStringExtra(INTENT_EXTRA_MESSAGE);
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        serviceIntent.setAction(fallbackAction);
        serviceIntent.putExtra(INTENT_EXTRA_SMS, (Serializable)sms);
        serviceIntent.putExtra(INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
        serviceIntent.putExtra("dictatedMessage", dictatedMessage);
        context.startService(serviceIntent);
    }

    protected void readNext(Context context) {
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        serviceIntent.setAction("org.chorem.android.saymytexts.READ_NEXT_SMS");
        context.startService(serviceIntent);
    }
}

