/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.inst;

import boofcv.core.image.ImageGenerator;
import boofcv.core.image.inst.SingleBandGenerator;
import boofcv.struct.image.ImageGray;
import java.lang.reflect.Array;

public class FactoryImageGenerator {
    public static <T extends ImageGray<T>> ImageGenerator<T> create(Class<T> type) {
        return new SingleBandGenerator<T>(type);
    }

    public static <T extends ImageGray<T>> ImageGenerator<T> create(T original) {
        return new WrapImage<T>(original);
    }

    public static class WrapImage<T extends ImageGray<T>>
    implements ImageGenerator<T> {
        T original;

        public WrapImage(T original) {
            this.original = original;
        }

        public T[] createArray(int number) {
            return (ImageGray[])Array.newInstance(this.original.getClass(), number);
        }

        public T createInstance(int width, int height) {
            return (T)((ImageGray)this.original.createNew(width, height));
        }

        public Class<T> getType() {
            return this.original.getClass();
        }
    }
}

