/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import org.jetbrains.annotations.Nullable;

public class PyramidDiscreteAverage<T extends ImageBase<T>>
extends PyramidDiscrete<T> {
    public PyramidDiscreteAverage(ImageType<T> imageType, boolean saveOriginalReference, @Nullable ConfigDiscreteLevels configLayers) {
        super(imageType, saveOriginalReference, configLayers);
    }

    protected PyramidDiscreteAverage(PyramidDiscreteAverage<T> orig) {
        super(orig);
    }

    public void process(T input) {
        super.initialize(((ImageBase)input).width, ((ImageBase)input).height);
        if (this.levelScales[0] == 1) {
            if (this.isSaveOriginalReference()) {
                this.setFirstLayer((ImageBase)input);
            } else {
                this.getLayer(0).setTo(input);
            }
        } else {
            AverageDownSampleOps.down(input, this.levelScales[0], this.getLayer(0));
        }
        for (int index = 1; index < this.getNumLayers(); ++index) {
            int width = this.levelScales[index] / this.levelScales[index - 1];
            AverageDownSampleOps.down(this.getLayer(index - 1), width, this.getLayer(index));
        }
    }

    public double getSampleOffset(int layer) {
        return (double)(this.levelScales[layer] - 1) / 2.0;
    }

    public double getSigma(int layer) {
        return 0.0;
    }

    public ImagePyramid<T> copyStructure() {
        return new PyramidDiscreteAverage<T>(this);
    }
}

