/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.ImageBandMath;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import org.jetbrains.annotations.Nullable;

public class GImageBandMath {
    public static <T extends ImageGray<T>> void minimum(Planar<T> input, T output) {
        GImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
    }

    public static <T extends ImageGray<T>> void minimum(Planar<T> input, T output, int startBand, int lastBand) {
        if (GrayU8.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayU8)output, startBand, lastBand);
        } else if (GrayU16.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayU16)output, startBand, lastBand);
        } else if (GrayS16.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayS16)output, startBand, lastBand);
        } else if (GrayS32.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayS32)output, startBand, lastBand);
        } else if (GrayS64.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayS64)output, startBand, lastBand);
        } else if (GrayF32.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayF32)output, startBand, lastBand);
        } else if (GrayF64.class == input.getBandType()) {
            ImageBandMath.minimum(input, (GrayF64)output, startBand, lastBand);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void maximum(Planar<T> input, T output) {
        GImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
    }

    public static <T extends ImageGray<T>> void maximum(Planar<T> input, T output, int startBand, int lastBand) {
        if (GrayU8.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayU8)output, startBand, lastBand);
        } else if (GrayU16.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayU16)output, startBand, lastBand);
        } else if (GrayS16.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayS16)output, startBand, lastBand);
        } else if (GrayS32.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayS32)output, startBand, lastBand);
        } else if (GrayS64.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayS64)output, startBand, lastBand);
        } else if (GrayF32.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayF32)output, startBand, lastBand);
        } else if (GrayF64.class == input.getBandType()) {
            ImageBandMath.maximum(input, (GrayF64)output, startBand, lastBand);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void average(Planar<T> input, T output) {
        GImageBandMath.average(input, output, 0, input.getNumBands() - 1);
    }

    public static <T extends ImageGray<T>> void average(Planar<T> input, T output, int startBand, int lastBand) {
        if (GrayU8.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayU8)output, startBand, lastBand);
        } else if (GrayU16.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayU16)output, startBand, lastBand);
        } else if (GrayS16.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayS16)output, startBand, lastBand);
        } else if (GrayS32.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayS32)output, startBand, lastBand);
        } else if (GrayS64.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayS64)output, startBand, lastBand);
        } else if (GrayF32.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayF32)output, startBand, lastBand);
        } else if (GrayF64.class == input.getBandType()) {
            ImageBandMath.average(input, (GrayF64)output, startBand, lastBand);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void median(Planar<T> input, T output) {
        GImageBandMath.median(input, output, 0, input.getNumBands() - 1);
    }

    public static <T extends ImageGray<T>> void median(Planar<T> input, T output, int startBand, int lastBand) {
        if (GrayU8.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayU8)output, startBand, lastBand);
        } else if (GrayU16.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayU16)output, startBand, lastBand);
        } else if (GrayS16.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayS16)output, startBand, lastBand);
        } else if (GrayS32.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayS32)output, startBand, lastBand);
        } else if (GrayS64.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayS64)output, startBand, lastBand);
        } else if (GrayF32.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayF32)output, startBand, lastBand);
        } else if (GrayF64.class == input.getBandType()) {
            ImageBandMath.median(input, (GrayF64)output, startBand, lastBand);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void stdDev(Planar<T> input, T output, @Nullable T avg) {
        GImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static <T extends ImageGray<T>> void stdDev(Planar<T> input, T output, @Nullable T avg, int startBand, int lastBand) {
        if (GrayU8.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayU8)output, (GrayU8)avg, startBand, lastBand);
        } else if (GrayU16.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayU16)output, (GrayU16)avg, startBand, lastBand);
        } else if (GrayS16.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayS16)output, (GrayS16)avg, startBand, lastBand);
        } else if (GrayS32.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayS32)output, (GrayS32)avg, startBand, lastBand);
        } else if (GrayS64.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayS64)output, (GrayS64)avg, startBand, lastBand);
        } else if (GrayF32.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayF32)output, (GrayF32)avg, startBand, lastBand);
        } else if (GrayF64.class == input.getBandType()) {
            ImageBandMath.stdDev(input, (GrayF64)output, (GrayF64)avg, startBand, lastBand);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }
}

