/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.NearestNeighborPixelS;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_U16
extends NearestNeighborPixelS<GrayU16> {
    private short[] data;

    public NearestNeighborPixel_U16() {
    }

    public NearestNeighborPixel_U16(GrayU16 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(GrayU16 image) {
        super.setImage(image);
        this.data = ((GrayU16)this.orig).data;
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((GrayU16)this.orig).startIndex + (int)y * this.stride + (int)x] & 0xFFFF;
    }

    public float get_border(float x, float y) {
        return ((ImageBorder_S32)this.border).get((int)Math.floor(x), (int)Math.floor(y));
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            return this.get_border(x, y);
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((GrayU16)this.orig).startIndex + yy * this.stride + xx] & 0xFFFF;
    }

    @Override
    public InterpolatePixelS<GrayU16> copy() {
        NearestNeighborPixel_U16 out = new NearestNeighborPixel_U16();
        out.setBorder(this.border.copy());
        return out;
    }

    @Override
    public ImageType<GrayU16> getImageType() {
        return ImageType.single(GrayU16.class);
    }
}

