/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;
import org.apache.fop.util.CloseBlockerOutputStream;

public abstract class AbstractPDFStream
extends PDFDictionary {
    private PDFFilterList filters;

    protected void setupFilterList() {
        if (!this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), "default");
        }
        this.prepareImplicitFilters();
        this.getDocument().applyEncryption(this);
    }

    public PDFFilterList getFilterList() {
        if (this.filters == null) {
            boolean hasFilterEntries;
            this.filters = this.getDocument() == null ? new PDFFilterList() : new PDFFilterList(this.getDocument().isEncryptionActive());
            boolean bl = hasFilterEntries = this.get("Filter") != null;
            if (hasFilterEntries) {
                this.filters.setDisableAllFilters(true);
            }
        }
        return this.filters;
    }

    protected abstract int getSizeHint() throws IOException;

    protected abstract void outputRawStreamData(OutputStream var1) throws IOException;

    protected int outputStreamData(StreamCache encodedStream, OutputStream out) throws IOException {
        int length = 0;
        byte[] p = AbstractPDFStream.encode("stream\n");
        out.write(p);
        length += p.length;
        encodedStream.outputContents(out);
        length += encodedStream.getSize();
        p = AbstractPDFStream.encode("\nendstream");
        out.write(p);
        return length += p.length;
    }

    protected StreamCache encodeStream() throws IOException {
        StreamCache encodedStream = StreamCacheFactory.getInstance().createStreamCache(this.getSizeHint());
        OutputStream filteredOutput = this.getFilterList().applyFilters(encodedStream.getOutputStream());
        this.outputRawStreamData(filteredOutput);
        filteredOutput.flush();
        filteredOutput.close();
        return encodedStream;
    }

    protected int encodeAndWriteStream(OutputStream out, PDFNumber refLength) throws IOException {
        int bytesWritten = 0;
        byte[] buf = AbstractPDFStream.encode("stream\n");
        out.write(buf);
        bytesWritten += buf.length;
        CloseBlockerOutputStream cbout = new CloseBlockerOutputStream(out);
        CountingOutputStream cout = new CountingOutputStream((OutputStream)cbout);
        OutputStream filteredOutput = this.getFilterList().applyFilters((OutputStream)cout);
        this.outputRawStreamData(filteredOutput);
        filteredOutput.close();
        refLength.setNumber(new Integer(cout.getCount()));
        bytesWritten += cout.getCount();
        buf = AbstractPDFStream.encode("\nendstream");
        out.write(buf);
        return bytesWritten += buf.length;
    }

    protected int output(OutputStream stream) throws IOException {
        Object lengthEntry;
        this.setupFilterList();
        CountingOutputStream cout = new CountingOutputStream(stream);
        Writer writer = PDFDocument.getWriterFor((OutputStream)cout);
        writer.write(this.getObjectID());
        StreamCache encodedStream = null;
        PDFNumber refLength = null;
        if (this.getDocument().isEncodingOnTheFly()) {
            refLength = new PDFNumber();
            this.getDocumentSafely().registerObject(refLength);
            lengthEntry = refLength;
        } else {
            encodedStream = this.encodeStream();
            lengthEntry = new Integer(encodedStream.getSize() + 1);
        }
        this.populateStreamDict(lengthEntry);
        this.writeDictionary((OutputStream)cout, writer);
        writer.flush();
        if (encodedStream == null) {
            this.encodeAndWriteStream((OutputStream)cout, refLength);
        } else {
            this.outputStreamData(encodedStream, (OutputStream)cout);
            encodedStream.clear();
        }
        writer.write("\nendobj\n");
        writer.flush();
        return cout.getCount();
    }

    protected void populateStreamDict(Object lengthEntry) {
        this.put("Length", lengthEntry);
        if (!this.getFilterList().isDisableAllFilters()) {
            this.getFilterList().putFilterDictEntries(this);
        }
    }

    protected void prepareImplicitFilters() {
    }
}

