/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.convert.converter.AbstractConverter;

public abstract class AbstractNumberConverter<N extends Number>
extends AbstractConverter<N> {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<Locale, NumberFormat> numberFormats = new ConcurrentHashMap();

    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat numberFormat = this.numberFormats.get(locale);
        if (numberFormat == null) {
            NumberFormat tmpNumberFormat;
            numberFormat = this.newNumberFormat(locale);
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).setParseBigDecimal(true);
            }
            if ((tmpNumberFormat = this.numberFormats.putIfAbsent(locale, numberFormat)) != null) {
                numberFormat = tmpNumberFormat;
            }
        }
        return (NumberFormat)numberFormat.clone();
    }

    protected abstract NumberFormat newNumberFormat(Locale var1);

    protected BigDecimal parse(Object value, BigDecimal min, BigDecimal max, Locale locale) {
        NumberFormat numberFormat;
        Number number;
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            char groupingSeparator = DecimalFormatSymbols.getInstance(locale).getGroupingSeparator();
            value = ((String)value).replaceAll("(\\d+)\\s(?=\\d)", "$1" + groupingSeparator);
        }
        if ((number = (Number)this.parse(numberFormat = this.getNumberFormat(locale), value, locale)) == null) {
            return null;
        }
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        if (min != null && bigDecimal.compareTo(min) < 0) {
            throw this.newConversionException("Value cannot be less than " + min, value, locale).setFormat(numberFormat);
        }
        if (max != null && bigDecimal.compareTo(max) > 0) {
            throw this.newConversionException("Value cannot be greater than " + max, value, locale).setFormat(numberFormat);
        }
        return bigDecimal;
    }

    @Override
    public String convertToString(N value, Locale locale) {
        NumberFormat fmt = this.getNumberFormat(locale);
        if (fmt != null) {
            return fmt.format(value);
        }
        return value.toString();
    }
}

