/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.apache.wicket.util.string.IStringIterator;
import org.apache.wicket.util.string.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Packages {
    public static String absolutePath(Class<?> p, String relativePath) {
        String packName = p != null ? Packages.extractPackageName(p) : "";
        return Packages.absolutePath(packName, relativePath);
    }

    public static String absolutePath(Package p, String relativePath) {
        return Packages.absolutePath(p.getName(), relativePath);
    }

    public static String absolutePath(String packageName, String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        StringList absolutePath = StringList.tokenize(packageName, ".");
        StringList folders = StringList.tokenize(relativePath, "/\\");
        IStringIterator iterator = folders.iterator();
        while (iterator.hasNext()) {
            String folder = iterator.next();
            if ("..".equals(folder)) {
                if (absolutePath.size() > 0) {
                    absolutePath.removeLast();
                    continue;
                }
                throw new IllegalArgumentException("Invalid path " + relativePath);
            }
            absolutePath.add(folder);
        }
        return absolutePath.join("/");
    }

    public static String extractPackageName(Class<?> forClass) {
        return Packages.parent(forClass.getName());
    }

    public static String parent(String packageName) {
        int pos = packageName.lastIndexOf(".");
        if (pos < 0 && (pos = packageName.lastIndexOf("/")) < 0) {
            pos = 0;
        }
        String parent = packageName.substring(0, pos);
        return parent;
    }

    public static String resolveScope(Class<?> forClass) {
        String packName = Packages.extractPackageName(forClass);
        return packName.replace('.', '/');
    }

    private Packages() {
    }
}

