/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.request.IRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerExecutor {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerExecutor.class);
    private IRequestHandler active;
    private final List<IRequestHandler> inactiveRequestHandlers = new ArrayList<IRequestHandler>();
    private IRequestHandler scheduledAfterCurrent = null;

    public IRequestHandler getActive() {
        return this.active;
    }

    public IRequestHandler execute(IRequestHandler handler) {
        this.active = handler;
        try {
            this.respond(handler);
        }
        finally {
            this.active = null;
            this.inactiveRequestHandlers.add(handler);
        }
        IRequestHandler scheduled = this.scheduledAfterCurrent;
        this.scheduledAfterCurrent = null;
        return scheduled;
    }

    protected abstract void respond(IRequestHandler var1);

    public void schedule(IRequestHandler handler) {
        this.scheduledAfterCurrent = handler;
    }

    public IRequestHandler next() {
        return this.scheduledAfterCurrent;
    }

    public void replaceAll(IRequestHandler handler) {
        if (this.active != null) {
            throw new ReplaceHandlerException(handler, true);
        }
        this.execute(handler);
    }

    public void detach() {
        if (this.active != null) {
            log.warn("request handler is still active.");
            this.inactiveRequestHandlers.add(this.active);
            this.active = null;
        }
        for (IRequestHandler handler : this.inactiveRequestHandlers) {
            try {
                this.detach(handler);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                log.error("Error detaching RequestHandler", (Throwable)exception);
            }
        }
    }

    protected abstract void detach(IRequestHandler var1);

    public static class ReplaceHandlerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean removeScheduled;
        private final IRequestHandler replacementRequestHandler;

        public ReplaceHandlerException(IRequestHandler replacementRequestHandler, boolean removeScheduled) {
            this.replacementRequestHandler = replacementRequestHandler;
            this.removeScheduled = removeScheduled;
        }

        public boolean getRemoveScheduled() {
            return this.removeScheduled;
        }

        public IRequestHandler getReplacementRequestHandler() {
            return this.replacementRequestHandler;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

