/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerStack {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerStack.class);
    private final LinkedList<IRequestHandler> requestHandlers = new LinkedList();
    private final List<IRequestHandler> inactiveRequestHandlers = new ArrayList<IRequestHandler>();
    private IRequestHandler scheduledAfterCurrent = null;

    public IRequestHandler getActive() {
        return this.requestHandlers.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IRequestHandler handler) {
        boolean first = this.requestHandlers.isEmpty();
        this.requestHandlers.add(handler);
        IRequestHandler replacementHandler = null;
        try {
            this.respond(handler);
        }
        catch (RuntimeException exception) {
            ReplaceHandlerException replacer = (ReplaceHandlerException)Exceptions.findCause((Throwable)exception, ReplaceHandlerException.class);
            if (replacer == null) {
                throw exception;
            }
            if (replacer.removeAll && !first) {
                throw exception;
            }
            replacementHandler = replacer.replacementRequestHandler;
        }
        finally {
            this.requestHandlers.poll();
            this.inactiveRequestHandlers.add(handler);
        }
        IRequestHandler scheduled = this.scheduledAfterCurrent;
        this.scheduledAfterCurrent = null;
        if (replacementHandler != null) {
            this.execute(replacementHandler);
        } else if (scheduled != null) {
            this.execute(scheduled);
        }
    }

    public final IRequestHandler resolveHandler(RuntimeException exception) {
        Args.notNull((Object)exception, (String)"exception");
        ReplaceHandlerException replacer = (ReplaceHandlerException)Exceptions.findCause((Throwable)exception, ReplaceHandlerException.class);
        return replacer != null ? replacer.replacementRequestHandler : null;
    }

    protected abstract void respond(IRequestHandler var1);

    public void schedule(IRequestHandler handler) {
        this.scheduledAfterCurrent = handler;
    }

    public IRequestHandler next() {
        return this.scheduledAfterCurrent;
    }

    public void replaceAll(IRequestHandler handler) {
        if (!this.requestHandlers.isEmpty()) {
            throw new ReplaceHandlerException(handler, true);
        }
        this.execute(handler);
    }

    public void detach() {
        if (!this.requestHandlers.isEmpty()) {
            log.warn("Some of the request handlers are still active.");
            this.inactiveRequestHandlers.addAll(this.requestHandlers);
            this.requestHandlers.clear();
        }
        for (IRequestHandler handler : this.inactiveRequestHandlers) {
            try {
                this.detach(handler);
            }
            catch (Exception exception) {
                log.error("Error detaching RequestHandler", (Throwable)exception);
            }
        }
    }

    protected abstract void detach(IRequestHandler var1);

    public static class ReplaceHandlerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean removeAll;
        private final IRequestHandler replacementRequestHandler;

        public ReplaceHandlerException(IRequestHandler replacementRequestHandler, boolean removeAll) {
            this.replacementRequestHandler = replacementRequestHandler;
            this.removeAll = removeAll;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

