/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.request.UrlDecoder;
import org.apache.wicket.request.UrlEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Url
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private final List<String> segments = Generics.newArrayList();
    private final List<QueryParameter> parameters = Generics.newArrayList();
    private String charsetName;
    private transient Charset _charset;
    private String protocol;
    private Integer port;
    private String host;

    private static QueryParameter parseQueryParameter(String qp, Charset charset) {
        if (qp.indexOf(61) == -1) {
            return new QueryParameter(Url.decodeParameter(qp, charset), "");
        }
        String[] parts = Strings.split((String)qp, (char)'=');
        return new QueryParameter(Url.decodeParameter(parts[0], charset), Url.decodeParameter(parts[1], charset));
    }

    public static Url parse(String url) {
        return Url.parse(url, null);
    }

    public static Url parse(String url, Charset charset) {
        String relativeUrl;
        String absoluteUrl;
        String queryString;
        Args.notNull((Object)url, (String)"url");
        Url result = new Url(charset);
        charset = result.getCharset();
        int queryAt = url.indexOf(63);
        if (queryAt == -1) {
            queryString = "";
            absoluteUrl = url;
        } else {
            absoluteUrl = url.substring(0, queryAt);
            queryString = url.substring(queryAt + 1);
        }
        int idxOfFirstSlash = absoluteUrl.indexOf(47);
        int protocolAt = absoluteUrl.indexOf("://");
        if (protocolAt > -1 && protocolAt < idxOfFirstSlash) {
            String hostAndPort;
            result.protocol = absoluteUrl.substring(0, protocolAt).toLowerCase(Locale.US);
            String afterProto = absoluteUrl.substring(protocolAt + 3);
            int relativeAt = afterProto.indexOf(47);
            if (relativeAt == -1) {
                relativeUrl = "";
                hostAndPort = afterProto;
            } else {
                relativeUrl = afterProto.substring(relativeAt);
                hostAndPort = afterProto.substring(0, relativeAt);
            }
            int portAt = hostAndPort.lastIndexOf(58);
            if (portAt == -1) {
                result.host = hostAndPort;
                result.port = Url.getDefaultPortForProtocol(result.protocol);
            } else {
                result.host = hostAndPort.substring(0, portAt);
                result.port = Integer.parseInt(hostAndPort.substring(portAt + 1));
            }
            if (relativeAt < 0) {
                relativeUrl = "/";
            }
        } else {
            relativeUrl = absoluteUrl;
        }
        if (relativeUrl.length() > 0) {
            boolean removeLast = false;
            if (relativeUrl.endsWith("/")) {
                relativeUrl = relativeUrl + "/x";
                removeLast = true;
            }
            String[] segmentArray = Strings.split((String)relativeUrl, (char)'/');
            if (removeLast) {
                segmentArray[segmentArray.length - 1] = null;
            }
            for (String s : segmentArray) {
                if (s == null) continue;
                result.segments.add(Url.decodeSegment(s, charset));
            }
        }
        if (queryString.length() > 0) {
            String[] queryArray;
            for (String s : queryArray = Strings.split((String)queryString, (char)'&')) {
                if (Strings.isEmpty((CharSequence)s)) continue;
                result.parameters.add(Url.parseQueryParameter(s, charset));
            }
        }
        return result;
    }

    private static Integer getDefaultPortForProtocol(String protocol) {
        if ("http".equals(protocol)) {
            return 80;
        }
        if ("https".equals(protocol)) {
            return 443;
        }
        if ("ftp".equals(protocol)) {
            return 21;
        }
        return null;
    }

    public Url() {
    }

    public Url(Charset charset) {
        this.setCharset(charset);
    }

    public Url(Url url) {
        Args.notNull((Object)url, (String)"url");
        this.segments.addAll(url.getSegments());
        this.parameters.addAll(url.getQueryParameters());
        this.setCharset(url.getCharset());
        this.setProtocol(url.getProtocol());
        this.setHost(url.getHost());
        this.setPort(url.getPort());
    }

    public Url(List<String> segments, List<QueryParameter> parameters) {
        this(segments, parameters, null);
    }

    public Url(List<String> segments, Charset charset) {
        this(segments, Collections.emptyList(), charset);
    }

    public Url(List<String> segments, List<QueryParameter> parameters, Charset charset) {
        Args.notNull(segments, (String)"segments");
        Args.notNull(parameters, (String)"parameters");
        this.segments.addAll(segments);
        this.parameters.addAll(parameters);
        this.setCharset(charset);
    }

    public Charset getCharset() {
        if (Strings.isEmpty((CharSequence)this.charsetName)) {
            this.charsetName = DEFAULT_CHARSET_NAME;
        }
        if (this._charset == null) {
            this._charset = Charset.forName(this.charsetName);
        }
        return this._charset;
    }

    private void setCharset(Charset charset) {
        if (charset == null) {
            this.charsetName = DEFAULT_CHARSET_NAME;
            this._charset = null;
        } else {
            this.charsetName = charset.name();
            this._charset = charset;
        }
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.parameters;
    }

    public boolean isAbsolute() {
        return !this.getSegments().isEmpty() && Strings.isEmpty((CharSequence)this.getSegments().get(0));
    }

    public void removeQueryParameters(String name) {
        Iterator<QueryParameter> i = this.getQueryParameters().iterator();
        while (i.hasNext()) {
            QueryParameter param = i.next();
            if (!Objects.equal((Object)name, (Object)param.getName())) continue;
            i.remove();
        }
    }

    public void removeLeadingSegments(int count) {
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.segments.size()), (Comparable)Integer.valueOf(count), (String)"count");
        for (int i = 0; i < count; ++i) {
            this.segments.remove(0);
        }
    }

    public void prependLeadingSegments(List<String> newSegments) {
        Args.notNull(newSegments, (String)"segments");
        this.segments.addAll(0, newSegments);
    }

    public void setQueryParameter(String name, Object value) {
        this.removeQueryParameters(name);
        this.addQueryParameter(name, value);
    }

    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            QueryParameter parameter = new QueryParameter(name, value.toString());
            this.getQueryParameters().add(parameter);
        }
    }

    public QueryParameter getQueryParameter(String name) {
        for (QueryParameter parameter : this.parameters) {
            if (!Objects.equal((Object)name, (Object)parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public StringValue getQueryParameterValue(String name) {
        QueryParameter parameter = this.getQueryParameter(name);
        if (parameter == null) {
            return StringValue.valueOf((String)null);
        }
        return StringValue.valueOf((String)parameter.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Url)) {
            return false;
        }
        Url rhs = (Url)obj;
        return ((Object)this.getSegments()).equals(rhs.getSegments()) && ((Object)this.getQueryParameters()).equals(rhs.getQueryParameters());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSegments(), this.getQueryParameters()});
    }

    private static String encodeSegment(String string, Charset charset) {
        return UrlEncoder.PATH_INSTANCE.encode(string, charset);
    }

    private static String decodeSegment(String string, Charset charset) {
        return UrlDecoder.PATH_INSTANCE.decode(string, charset);
    }

    private static String encodeParameter(String string, Charset charset) {
        return UrlEncoder.QUERY_INSTANCE.encode(string, charset);
    }

    private static String decodeParameter(String string, Charset charset) {
        return UrlDecoder.QUERY_INSTANCE.decode(string, charset);
    }

    public String toString() {
        return this.toString(this.getCharset());
    }

    @Deprecated
    public String toAbsoluteString() {
        return this.toAbsoluteString(this.getCharset());
    }

    @Deprecated
    public String toAbsoluteString(Charset charset) {
        StringBuilder result = new StringBuilder();
        String protocol = this.protocol;
        if (Strings.isEmpty((CharSequence)protocol)) {
            protocol = "http";
        }
        if (!Strings.isEmpty((CharSequence)this.host)) {
            result.append(protocol);
            result.append("://");
            result.append(this.host);
            if (this.port != null && !this.port.equals(Url.getDefaultPortForProtocol(protocol))) {
                result.append(':');
                result.append(this.port);
            }
        }
        return Strings.join((String)"/", (String[])new String[]{result.toString(), this.toString()});
    }

    public String toString(StringMode mode, Charset charset) {
        StringBuilder result = new StringBuilder();
        String path = this.getPath(charset);
        if (StringMode.FULL == mode) {
            if (Strings.isEmpty((CharSequence)this.host)) {
                throw new IllegalStateException("Cannot render this url in " + StringMode.FULL.name() + " mode because it does not have a host set.");
            }
            String protocol = this.protocol;
            if (Strings.isEmpty((CharSequence)protocol)) {
                protocol = "http";
            }
            result.append(protocol);
            result.append("://");
            result.append(this.host);
            if (this.port != null && !this.port.equals(Url.getDefaultPortForProtocol(protocol))) {
                result.append(':');
                result.append(this.port);
            }
            if (path.contains("..")) {
                throw new IllegalStateException("Cannot render this url in " + StringMode.FULL.name() + " mode because it has a `..` segment: " + this.toString());
            }
            if (!path.startsWith("/")) {
                result.append('/');
            }
        }
        result.append(path);
        result.append(this.getQueryString(charset));
        return result.toString();
    }

    public String toString(StringMode mode) {
        return this.toString(mode, this.getCharset());
    }

    public String toString(Charset charset) {
        return this.toString(StringMode.LOCAL, charset);
    }

    private boolean isLastSegmentReal() {
        if (this.segments.isEmpty()) {
            return false;
        }
        String last = this.segments.get(this.segments.size() - 1);
        return last.length() > 0 && !".".equals(last) && !"..".equals(last);
    }

    private boolean isLastSegmentEmpty(List<String> segments) {
        if (segments.isEmpty()) {
            return false;
        }
        String last = segments.get(segments.size() - 1);
        return last.length() == 0;
    }

    private boolean isLastSegmentEmpty() {
        return this.isLastSegmentEmpty(this.segments);
    }

    private boolean isAtLeastOnSegmentReal(List<String> segments) {
        for (String s : segments) {
            if (s.length() <= 0 || ".".equals(s) || "..".equals(s)) continue;
            return true;
        }
        return false;
    }

    public void concatSegments(List<String> segments) {
        boolean checkedLastSegment = false;
        if (!this.isAtLeastOnSegmentReal(segments) && !this.isLastSegmentEmpty(segments)) {
            segments = new ArrayList<String>(segments);
            segments.add("");
        }
        for (String s : segments) {
            if (".".equals(s)) continue;
            if ("..".equals(s) && !this.segments.isEmpty()) {
                this.segments.remove(this.segments.size() - 1);
                continue;
            }
            if (!checkedLastSegment) {
                if (this.isLastSegmentReal() || this.isLastSegmentEmpty()) {
                    this.segments.remove(this.segments.size() - 1);
                }
                checkedLastSegment = true;
            }
            this.segments.add(s);
        }
        if (this.segments.size() == 1 && this.segments.get(0).length() == 0) {
            this.segments.clear();
        }
    }

    public void resolveRelative(Url relative) {
        if (this.getSegments().size() > 0) {
            this.getSegments().remove(this.getSegments().size() - 1);
        }
        while (!relative.getSegments().isEmpty()) {
            if (".".equals(relative.getSegments().get(0))) {
                relative.getSegments().remove(0);
                continue;
            }
            if ("".equals(relative.getSegments().get(0))) {
                relative.getSegments().remove(0);
                continue;
            }
            if (!"..".equals(relative.getSegments().get(0))) break;
            relative.getSegments().remove(0);
            if (this.getSegments().isEmpty()) continue;
            this.getSegments().remove(this.getSegments().size() - 1);
        }
        if (!this.getSegments().isEmpty() && relative.getSegments().isEmpty()) {
            this.getSegments().add("");
        }
        this.getSegments().addAll(relative.getSegments());
        this.parameters.clear();
        this.parameters.addAll(relative.getQueryParameters());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath(Charset charset) {
        Args.notNull((Object)charset, (String)"charset");
        StringBuilder path = new StringBuilder();
        boolean slash = false;
        for (String segment : this.getSegments()) {
            if (slash) {
                path.append('/');
            }
            path.append(Url.encodeSegment(segment, charset));
            slash = true;
        }
        return path.toString();
    }

    public String getPath() {
        return this.getPath(this.getCharset());
    }

    public String getQueryString(Charset charset) {
        Args.notNull((Object)charset, (String)"charset");
        StringBuilder query = new StringBuilder();
        for (QueryParameter parameter : this.getQueryParameters()) {
            query.append(query.length() == 0 ? (char)'?' : '&');
            query.append(parameter.toString(charset));
        }
        return query.toString();
    }

    public String getQueryString() {
        return this.getQueryString(this.getCharset());
    }

    public Url canonical() {
        Url url = new Url(this);
        url.segments.clear();
        for (int i = 0; i < this.segments.size(); ++i) {
            String segment = this.segments.get(i);
            if (".".equals(segment)) continue;
            if (i + 1 < this.segments.size() && "..".equals(this.segments.get(i + 1))) {
                ++i;
                continue;
            }
            url.segments.add(segment);
        }
        return url;
    }

    public static final class QueryParameter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String value;

        public QueryParameter(String name, String value) {
            Args.notNull((Object)name, (String)"name");
            Args.notNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueryParameter)) {
                return false;
            }
            QueryParameter rhs = (QueryParameter)obj;
            return Objects.equal((Object)this.getName(), (Object)rhs.getName()) && Objects.equal((Object)this.getValue(), (Object)rhs.getValue());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getName(), this.getValue()});
        }

        public String toString() {
            return this.toString(Charset.forName(Url.DEFAULT_CHARSET_NAME));
        }

        public String toString(Charset charset) {
            StringBuilder result = new StringBuilder();
            result.append(Url.encodeParameter(this.getName(), charset));
            if (!Strings.isEmpty((CharSequence)this.getValue())) {
                result.append('=');
                result.append(Url.encodeParameter(this.getValue(), charset));
            }
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringMode {
        LOCAL,
        FULL;

    }
}

