/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Delay;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

public class DiscussionMessage {
    private Stanza message;
    private String fromNick;
    private Calendar timestamp;

    public DiscussionMessage(Stanza stanza, Occupant from) {
        this(stanza, from, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
    }

    public DiscussionMessage(Stanza stanza, Occupant from, Calendar timestamp) {
        this.message = stanza;
        this.fromNick = from.getNick();
        this.timestamp = (Calendar)timestamp.clone();
    }

    public Calendar getTimestamp() {
        return (Calendar)this.timestamp.clone();
    }

    public String getNick() {
        return this.fromNick;
    }

    public Stanza createStanza(Occupant receiver, boolean includeJid) {
        Entity roomJid = this.message.getTo();
        StanzaBuilder builder = StanzaBuilder.createForward((Stanza)this.message, (Entity)new EntityImpl(roomJid, this.fromNick), (Entity)receiver.getJid());
        Object delayFrom = includeJid ? this.message.getFrom() : new EntityImpl(roomJid, this.fromNick);
        Delay delay = new Delay((Entity)delayFrom, this.timestamp);
        builder.addPreparedElement((XMLElement)delay);
        return (Stanza)builder.build();
    }

    public boolean hasSubject() {
        return !this.message.getInnerElementsNamed("subject").isEmpty();
    }

    public boolean hasBody() {
        return !this.message.getInnerElementsNamed("body").isEmpty();
    }
}

