/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.membership.MembershipProviderBase;
import org.apache.catalina.tribes.membership.cloud.StreamProvider;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class CloudMembershipProvider
extends MembershipProviderBase
implements Heartbeat,
ChannelListener {
    private static final Log log = LogFactory.getLog(CloudMembershipProvider.class);
    protected static final StringManager sm = StringManager.getManager(CloudMembershipProvider.class);
    protected static final String CUSTOM_ENV_PREFIX = "OPENSHIFT_KUBE_PING_";
    protected String url;
    protected StreamProvider streamProvider;
    protected int connectionTimeout;
    protected int readTimeout;
    protected Instant startTime;
    protected MessageDigest md5;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected String localIp;
    protected int port;
    protected long expirationTime = 5000L;

    public CloudMembershipProvider() {
        try {
            this.md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected static String getEnv(String ... keys) {
        String key;
        String val = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (val = AccessController.doPrivileged(() -> CloudMembershipProvider.lambda$getEnv$0(key = stringArray[i]))) == null; ++i) {
        }
        return val;
    }

    protected String getNamespace() {
        String namespace = CloudMembershipProvider.getEnv("KUBERNETES_NAMESPACE", "OPENSHIFT_KUBE_PING_NAMESPACE");
        if (namespace == null || namespace.length() == 0) {
            log.warn((Object)sm.getString("kubernetesMembershipProvider.noNamespace"));
            namespace = "tomcat";
        }
        return namespace;
    }

    @Override
    public void init(Properties properties) throws IOException {
        this.startTime = Instant.now();
        this.connectionTimeout = Integer.parseInt(properties.getProperty("connectionTimeout", "1000"));
        this.readTimeout = Integer.parseInt(properties.getProperty("readTimeout", "1000"));
        this.localIp = InetAddress.getLocalHost().getHostAddress();
        this.port = Integer.parseInt(properties.getProperty("tcpListenPort"));
        this.expirationTime = Long.parseLong(properties.getProperty("expirationTime", "5000"));
    }

    @Override
    public void start(int level) throws Exception {
        if (this.membership == null) {
            this.membership = new Membership(this.service.getLocalMember(true));
        }
        this.service.getChannel().addChannelListener(this);
    }

    @Override
    public boolean stop(int level) throws Exception {
        return true;
    }

    @Override
    public void heartbeat() {
        Member[] expired;
        Member[] announcedMembers;
        for (final Member member : announcedMembers = this.fetchMembers()) {
            if (!this.membership.memberAlive(member)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member added: " + member));
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String name = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("CloudMembership-memberAdded");
                        CloudMembershipProvider.this.membershipListener.memberAdded(member);
                    }
                    finally {
                        Thread.currentThread().setName(name);
                    }
                }
            };
            this.executor.execute(r);
        }
        for (final Member member : expired = this.membership.expire(this.expirationTime)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member disappeared: " + member));
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String name = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("CloudMembership-memberDisappeared");
                        CloudMembershipProvider.this.membershipListener.memberDisappeared(member);
                    }
                    finally {
                        Thread.currentThread().setName(name);
                    }
                }
            };
            this.executor.execute(r);
        }
    }

    protected abstract Member[] fetchMembers();

    @Override
    public void messageReceived(Serializable msg, Member sender) {
    }

    @Override
    public boolean accept(Serializable msg, Member sender) {
        return false;
    }

    private static /* synthetic */ String lambda$getEnv$0(String key) {
        return System.getenv(key);
    }
}

