/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;

public class CSVUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[][] EMPTY_DOUBLE_STRING_ARRAY = new String[0][0];

    public static String printLine(String[] values) {
        StringWriter stringWriter = new StringWriter();
        CSVPrinter csvPrinter = new CSVPrinter(stringWriter);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                values[i] = "null";
                continue;
            }
            if (!values[i].equals("null")) continue;
            values[i] = "\"null\"";
        }
        csvPrinter.println(values);
        return stringWriter.toString().trim();
    }

    public static String[][] parse(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        String[][] result = new CSVParser(new StringReader(s)).getAllValues();
        if (result == null) {
            result = EMPTY_DOUBLE_STRING_ARRAY;
        }
        return result;
    }

    public static String[] parseLine(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        if (s.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return new CSVParser(new StringReader(s)).getLine();
    }
}

