/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.validator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesValidatorImpl
implements PreferencesValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesValidatorImpl.class);
    public static final String CHECK_VALIDATOR_COUNT = "checkValidatorCount";
    private static final Map<String, Integer> INSTANCE_COUNTER = new HashMap();
    private int validateInvoked = 0;

    public PreferencesValidatorImpl() {
        Integer count;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating validator instance: " + this.getClass().getName());
        }
        count = (count = (Integer)INSTANCE_COUNTER.get(this.getClass().getName())) == null ? new Integer(1) : new Integer(count + 1);
        INSTANCE_COUNTER.put(this.getClass().getName(), count);
    }

    public void validate(PortletPreferences preferences) throws ValidatorException {
        ++this.validateInvoked;
        String value = preferences.getValue(CHECK_VALIDATOR_COUNT, null);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.checkValidatorCount();
        }
        String[] DEFAULT_VALUES = new String[]{"no values"};
        ArrayList<String> failedNames = new ArrayList<String>();
        Enumeration en = preferences.getNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String[] values = preferences.getValues(name, DEFAULT_VALUES);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].equals(values[i].trim())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Validation failed: value has white spaces: name=" + name + "; value=|" + values[i] + "|");
                }
                failedNames.add(name);
            }
        }
        if (!failedNames.isEmpty()) {
            throw new ValidatorException("One or more preferences do not pass the validation.", failedNames);
        }
    }

    private void checkValidatorCount() throws ValidatorException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking validator count...");
        }
        Integer instanceCreated = (Integer)INSTANCE_COUNTER.get(this.getClass().getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Method validate() invoked " + this.validateInvoked + " times.");
            LOG.debug("Validator created " + instanceCreated + " times.");
        }
        if (instanceCreated != 1) {
            throw new ValidatorException(instanceCreated.toString() + " validator instances were created, " + "expected 1 validator instance per portlet definition.", null);
        }
    }
}

