/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.writebehind;

import java.util.Collection;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.writebehind.AbstractWriteBehindCallback;
import org.apache.openjpa.writebehind.WriteBehindCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWriteBehindCallback
extends AbstractWriteBehindCallback {
    private int _sleepTime = 2000;
    private boolean done = false;
    private WriteBehindCache _cache = null;
    private Broker _broker;

    @Override
    public void initialize(Broker broker, WriteBehindCache cache) {
        this._cache = cache;
        this._broker = broker;
    }

    @Override
    public Collection<Exception> flush() {
        Collection<Exception> errors = null;
        StoreManager storeManager = this._broker.getStoreManager().getInnermostDelegate();
        Collection<OpenJPAStateManager> sms = null;
        if (this._cache != null && !this._cache.isEmpty()) {
            sms = this._cache.getStateManagers();
            this._cache.clear();
        }
        if (sms != null && !sms.isEmpty()) {
            storeManager.retainConnection();
            storeManager.begin();
            errors = storeManager.flush(sms);
            if (errors != null && !errors.isEmpty()) {
                for (Exception e : errors) {
                    e.printStackTrace();
                }
            }
            storeManager.commit();
            storeManager.releaseConnection();
        }
        return errors;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                Thread.sleep(this._sleepTime);
                this.handleExceptions(this.flush());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void handleExceptions(Collection<Exception> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            this.done = true;
            for (Exception e : exceptions) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        this.done = true;
        this.flush();
        this._broker.close();
    }

    public int getSleepTime() {
        return this._sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this._sleepTime = sleepTime;
    }
}

