/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SliceThread
extends Thread {
    private final Thread _parent;

    public SliceThread(String name, Thread parent, Runnable r) {
        super(r, name);
        this._parent = parent;
    }

    public SliceThread(Thread parent, Runnable r) {
        super(r);
        this._parent = parent;
    }

    public Thread getParent() {
        return this._parent;
    }

    public static ExecutorService newPool(int size) {
        return new ThreadPoolExecutor(size, size, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SliceThreadFactory());
    }

    static class SliceThreadFactory
    implements ThreadFactory {
        int n = 0;

        SliceThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread parent = Thread.currentThread();
            return new SliceThread(parent.getName() + "-slice-" + this.n++, parent, r);
        }
    }
}

