/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.FetchPathImpl;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FromImpl<Z, X>
extends PathImpl<Z, X>
implements From<Z, X> {
    private Set<Join<X, ?>> _joins;
    private Set<Fetch<X, ?>> _fetches;
    private Type<X> type;

    protected FromImpl(AbstractManagedType<X> type) {
        super(type.getJavaType());
        this.type = type;
    }

    protected FromImpl(PathImpl<?, Z> parent, Members.Member<? super Z, ?> m, Class<X> x) {
        super(parent, m, x);
        this.type = m.getType();
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    @Override
    public Set<Join<X, ?>> getJoins() {
        return Expressions.returnCopy(this._joins);
    }

    @Override
    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        Joins.SingularJoin join = new Joins.SingularJoin(this, (Members.SingularAttributeImpl)attribute, jt);
        this.addJoin(join);
        return join;
    }

    @Override
    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    @Override
    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        Joins.Collection join = new Joins.Collection(this, (Members.CollectionAttributeImpl)collection, jt);
        this.addJoin(join);
        return join;
    }

    @Override
    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    @Override
    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        Joins.Set join = new Joins.Set(this, (Members.SetAttributeImpl)set, jt);
        this.addJoin(join);
        return join;
    }

    @Override
    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    @Override
    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        Joins.List join = new Joins.List(this, (Members.ListAttributeImpl)list, jt);
        this.addJoin(join);
        return join;
    }

    @Override
    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    @Override
    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        Joins.Map join = new Joins.Map(this, (Members.MapAttributeImpl)map, jt);
        this.addJoin(join);
        return join;
    }

    @Override
    public <W, Y> Join<W, Y> join(String attr) {
        return this.join(attr, JoinType.INNER);
    }

    @Override
    public <W, Y> Join<W, Y> join(String attr, JoinType jt) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getSingularAttribute(attr), jt);
    }

    @Override
    public <W, Y> CollectionJoin<W, Y> joinCollection(String attr) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getCollection(attr), JoinType.INNER);
    }

    @Override
    public <W, Y> CollectionJoin<W, Y> joinCollection(String attr, JoinType jt) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getCollection(attr), jt);
    }

    @Override
    public <W, Y> ListJoin<W, Y> joinList(String attr) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getList(attr), JoinType.INNER);
    }

    @Override
    public <W, Y> ListJoin<W, Y> joinList(String attr, JoinType jt) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getList(attr), jt);
    }

    @Override
    public <W, K, V> MapJoin<W, K, V> joinMap(String attr) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getMap(attr));
    }

    @Override
    public <W, K, V> MapJoin<W, K, V> joinMap(String attr, JoinType jt) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getMap(attr));
    }

    @Override
    public <W, Y> SetJoin<W, Y> joinSet(String attr) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getSet(attr));
    }

    @Override
    public <W, Y> SetJoin<W, Y> joinSet(String attr, JoinType jt) {
        this.assertJoinable();
        return this.join(((ManagedType)this.type).getSet(attr), jt);
    }

    void assertJoinable() {
        if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
            throw new IllegalArgumentException(this + " is a basic path and can not be navigated to ");
        }
    }

    private void addJoin(Join<X, ?> join) {
        if (this._joins == null) {
            this._joins = new HashSet();
        }
        this._joins.add(join);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)((Object)assoc), jt);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc, JoinType jt) {
        return this.addFetch((Members.Member)((Object)assoc), jt);
    }

    @Override
    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    @Override
    public <X, Y> Fetch<X, Y> fetch(String assocName) {
        return this.fetch(assocName, JoinType.INNER);
    }

    @Override
    public <X, Y> Fetch<X, Y> fetch(String name, JoinType jt) {
        this.assertJoinable();
        Attribute attr = ((ManagedType)this.type).getAttribute(name);
        if (attr.isCollection()) {
            return this.fetch((PluralAttribute)attr, jt);
        }
        return this.fetch((SingularAttribute)attr, jt);
    }

    @Override
    public Set<Fetch<X, ?>> getFetches() {
        return Expressions.returnCopy(this._fetches);
    }

    private <Y> Fetch<X, Y> addFetch(Members.Member<? super X, Y> member, JoinType jt) {
        FetchPathImpl<? super X, Y> fetch = new FetchPathImpl<X, Y>(this, member, jt);
        if (this._fetches == null) {
            this._fetches = new HashSet();
        }
        this._fetches.add(fetch);
        return fetch;
    }

    @Override
    public void acceptVisit(CriteriaExpressionVisitor visitor) {
        Expressions.acceptVisit(visitor, this, this._joins == null ? null : this._joins.toArray(new ExpressionImpl[this._joins.size()]));
    }
}

