/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.ObjectFactory;
import org.apache.openjpa.lib.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FillStrategy<T> {
    public static final Localizer _loc = Localizer.forPackage(FillStrategy.class);

    public T fill(Object[] var1, Class<?>[] var2, String[] var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory<T>
    implements FillStrategy<T> {
        final ObjectFactory<T> factory;
        final Method putMethod;
        final boolean isArray;

        public Factory(ObjectFactory<T> factory, Method put) {
            this.factory = factory;
            this.putMethod = put;
            if (put == null || put.getParameterTypes().length != 2) {
                throw new IllegalArgumentException(_loc.get("fill-factory-bad-put", put).getMessage());
            }
            Class<?> keyType = this.putMethod.getParameterTypes()[0];
            this.isArray = keyType == Integer.TYPE || keyType == Integer.class;
        }

        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            int i = 0;
            Object key = null;
            T result = this.factory.newInstance();
            try {
                for (i = 0; i < values.length; ++i) {
                    key = this.isArray ? Integer.valueOf(i) : aliases[i];
                    this.putMethod.invoke(result, key, Filters.convert(values[i], types[i]));
                }
                return result;
            }
            catch (InvocationTargetException t) {
                throw new RuntimeException(_loc.get("fill-factory-error", new Object[]{this.putMethod, key, values[i], types[i]}).getMessage(), t.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-factory-error", new Object[]{this.putMethod, key, values[i], types[i]}).getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Assign<T>
    implements FillStrategy<T> {
        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            try {
                return (T)values[0];
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-assign-error", Arrays.toString(values), Arrays.toString(types)).getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bean<T>
    implements FillStrategy<T> {
        private final Class<T> cls;
        private Method[] setters;

        public Bean(Class<T> cls) {
            this.cls = cls;
        }

        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            int i = 0;
            try {
                if (this.setters == null) {
                    this.setters = new Method[values.length];
                }
                T bean = this.cls.newInstance();
                for (i = 0; i < values.length; ++i) {
                    if (this.setters[i] == null) {
                        this.setters[i] = Reflection.findSetter(this.cls, aliases[i], false);
                        if (this.setters[i] == null) {
                            throw new RuntimeException(_loc.get("fill-bean-setter", this.cls, aliases[i]).getMessage());
                        }
                    }
                    this.setters[i].invoke(bean, Filters.convert(values[i], types[i]));
                }
                return bean;
            }
            catch (InvocationTargetException t) {
                throw new RuntimeException(_loc.get("fill-bean-error", this.setters[i], values[i], types[i]).getMessage(), t.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-bean-error", this.setters[i], values[i], types[i]).getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewInstance<T>
    implements FillStrategy<T> {
        private Constructor<? extends T> cons;
        private Class<T> cls;

        public NewInstance(Constructor<? extends T> cons) {
            this.cons = cons;
        }

        public NewInstance(Class<T> cls) {
            this.cls = cls;
        }

        <X> Constructor<X> findConstructor(Class<X> cls, Class<?>[] types) {
            try {
                return cls.getConstructor(types);
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-ctor-none", cls, Arrays.toString(types)).getMessage());
            }
        }

        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            if (this.cons == null) {
                this.cons = this.findConstructor(this.cls, types);
            }
            try {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = Filters.convert(values[i], types[i]);
                }
                return this.cons.newInstance(values);
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-ctor-error", this.cons, Arrays.toString(values), Arrays.toString(types)).getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map<T>
    implements FillStrategy<T> {
        private final Method putMethod;

        public Map(Method put) {
            if (put == null || put.getParameterTypes().length != 2) {
                throw new IllegalArgumentException(_loc.get("fill-bad-put", put).getMessage());
            }
            this.putMethod = put;
        }

        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            int i = 0;
            try {
                Object map = this.putMethod.getDeclaringClass().newInstance();
                for (i = 0; i < values.length; ++i) {
                    this.putMethod.invoke(map, aliases[i], values[i]);
                }
                return (T)map;
            }
            catch (InvocationTargetException t) {
                throw new RuntimeException(_loc.get("fill-map-error", this.putMethod, aliases[i], values[i]).getMessage(), t.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("fill-map-error", this.putMethod, aliases[i], values[i]).getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array<T>
    implements FillStrategy<T> {
        private final Class<?> cls;

        public Array(Class<T> arrayCls) {
            if (arrayCls == null || !arrayCls.isArray()) {
                throw new IllegalArgumentException(_loc.get("fill-bad-array", arrayCls).getMessage());
            }
            this.cls = arrayCls.getComponentType();
        }

        @Override
        public T fill(Object[] values, Class<?>[] types, String[] aliases) {
            Object array = java.lang.reflect.Array.newInstance(this.cls, values.length);
            System.arraycopy(values, 0, array, 0, values.length);
            return (T)array;
        }
    }
}

