/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.ReflectingPersistenceCapable;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.ContainerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerRelationMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.LRSMapFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.LRSProxyMap;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

public abstract class MapTableFieldStrategy
extends ContainerFieldStrategy
implements LRSMapFieldStrategy {
    private static final Localizer _loc = Localizer.forPackage(MapTableFieldStrategy.class);

    public FieldMapping getFieldMapping() {
        return this.field;
    }

    public ClassMapping[] getIndependentKeyMappings(boolean traverse) {
        return traverse ? this.field.getKeyMapping().getIndependentTypeMappings() : ClassMapping.EMPTY_MAPPINGS;
    }

    public ClassMapping[] getIndependentValueMappings(boolean traverse) {
        return traverse ? this.field.getElementMapping().getIndependentTypeMappings() : ClassMapping.EMPTY_MAPPINGS;
    }

    public ForeignKey getJoinForeignKey(ClassMapping cls) {
        return this.field.getJoinForeignKey();
    }

    public Object deriveKey(JDBCStore store, Object value) {
        return null;
    }

    public Object deriveValue(JDBCStore store, Object key) {
        return null;
    }

    public Joins joinKeyRelation(Joins joins, ClassMapping key) {
        return this.joinKeyRelation(joins, false, false);
    }

    public Joins joinValueRelation(Joins joins, ClassMapping val) {
        return this.joinRelation(joins, false, false);
    }

    public void map(boolean adapt) {
        if (this.field.getTypeCode() != 13) {
            throw new MetaDataException(_loc.get("not-map", this.field));
        }
        if (this.field.getKey().getValueMappedBy() != null) {
            throw new MetaDataException(_loc.get("mapped-by-key", this.field));
        }
        if (this.field.isUni1ToMFK()) {
            return;
        }
        if (this.field.isBiMTo1JT()) {
            this.field.setBi1MJoinTableInfo();
        }
        this.field.getValueInfo().assertNoSchemaComponents(this.field, !adapt);
    }

    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Row row = rm.getAllRows(this.field.getTable(), 2);
        row.whereForeignKey(this.field.getJoinForeignKey(), sm);
        rm.flushAllRows(row);
    }

    public int supportsSelect(Select sel, int type, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        if (this.field.isLRS()) {
            sm.storeObjectField(this.field.getIndex(), new LRSProxyMap(this));
            return;
        }
        Joins[] joins = new Joins[2];
        Result[] res = this.getResults(sm, store, fetch, 2, joins, false);
        try {
            Map map = (Map)sm.newProxy(this.field.getIndex());
            while (res[0].next() && (res[1] == res[0] || res[1].next())) {
                Object key = this.loadKey(sm, store, fetch, res[0], joins[0]);
                Object val = this.loadValue(sm, store, fetch, res[1], joins[1]);
                map.put(key, val);
            }
            sm.storeObject(this.field.getIndex(), map);
        }
        finally {
            res[0].close();
            if (res[1] != res[0]) {
                res[1].close();
            }
        }
    }

    public Object loadKeyProjection(JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        return this.loadKey(null, store, fetch, res, joins);
    }

    public Object loadProjection(JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        return this.loadValue(null, store, fetch, res, joins);
    }

    public Joins join(Joins joins, boolean forceOuter) {
        return this.field.join(joins, forceOuter, true);
    }

    public Joins joinKey(Joins joins, boolean forceOuter) {
        return this.field.join(joins, forceOuter, true);
    }

    protected ForeignKey getJoinForeignKey() {
        return this.field.getJoinForeignKey();
    }

    protected ClassMapping[] getIndependentElementMappings(boolean traverse) {
        return ClassMapping.EMPTY_MAPPINGS;
    }

    protected void handleMappedByForeignKey(boolean adapt) {
        boolean criteria = this.field.getValueInfo().getUseClassCriteria();
        FieldMapping mapped = this.field.getMappedByMapping();
        if (mapped != null) {
            this.field.getValueInfo().assertNoSchemaComponents(this.field, !adapt);
            mapped.resolve(1 | 2);
            if (!mapped.isMapped() || mapped.isSerialized()) {
                throw new MetaDataException(_loc.get("mapped-by-unmapped", this.field, mapped));
            }
            if (mapped.getTypeCode() == 15) {
                if (mapped.getJoinDirection() == 0) {
                    this.field.setJoinDirection(1);
                    this.field.setColumns(mapped.getDefiningMapping().getPrimaryKeyColumns());
                } else if (this.isTypeUnjoinedSubclass(mapped)) {
                    throw new MetaDataException(_loc.get("mapped-inverse-unjoined", this.field.getName(), this.field.getDefiningMapping(), mapped));
                }
                ForeignKey fk = mapped.getForeignKey(this.field.getDefiningMapping());
                this.field.setForeignKey(fk);
                this.field.setJoinForeignKey(fk);
            } else if (mapped.getElement().getTypeCode() == 15) {
                if (this.isTypeUnjoinedSubclass(mapped.getElementMapping())) {
                    throw new MetaDataException(_loc.get("mapped-inverse-unjoined", this.field.getName(), this.field.getDefiningMapping(), mapped));
                }
                Log log = this.field.getRepository().getLog();
                if (log.isInfoEnabled()) {
                    log.info(_loc.get("coll-owner", this.field, mapped));
                }
                ValueMapping elem = mapped.getElementMapping();
                ForeignKey fk = elem.getForeignKey();
                this.field.setJoinForeignKey(fk);
                this.field.getElementMapping().setForeignKey(mapped.getJoinForeignKey());
            } else {
                throw new MetaDataException(_loc.get("not-inv-relation", this.field, mapped));
            }
            this.field.setUseClassCriteria(criteria);
            return;
        }
        ValueMapping val = this.field.getElementMapping();
        val.getValueInfo().setColumns(this.field.getValueInfo().getColumns());
        if (val.getTypeMapping().isMapped()) {
            ValueMappingInfo vinfo = val.getValueInfo();
            ForeignKey fk = vinfo.getTypeJoin(val, null, false, adapt);
            val.setForeignKey(fk);
            val.setColumnIO(vinfo.getColumnIO());
        } else {
            RelationStrategies.mapRelationToUnmappedPC(val, "value", adapt);
        }
        val.mapConstraints("value", adapt);
    }

    protected boolean isTypeUnjoinedSubclass(ValueMapping mapped) {
        for (ClassMapping def = this.field.getDefiningMapping(); def != null; def = def.getJoinablePCSuperclassMapping()) {
            if (def != mapped.getTypeMapping()) continue;
            return false;
        }
        return true;
    }

    protected boolean populateKey(Row row, OpenJPAStateManager valsm, Object obj, StoreContext ctx, RowManager rm, JDBCStore store) throws SQLException {
        ClassMapping meta = (ClassMapping)valsm.getMetaData();
        FieldMapping fm = this.getFieldMapping(meta);
        if (fm == null) {
            return false;
        }
        Map mapObj = (Map)valsm.fetchObject(fm.getIndex());
        Set entrySets = mapObj.entrySet();
        boolean found = false;
        for (Map.Entry entry : entrySets) {
            Object value = entry.getValue();
            if (obj instanceof ReflectingPersistenceCapable) {
                obj = ((ReflectingPersistenceCapable)obj).getManagedInstance();
            }
            if (value != obj) continue;
            Row newRow = (Row)((RowImpl)row).clone();
            Object keyObj = entry.getKey();
            FieldStrategy strat = fm.getStrategy();
            if (strat instanceof HandlerRelationMapTableFieldStrategy) {
                HandlerRelationMapTableFieldStrategy hrStrat = (HandlerRelationMapTableFieldStrategy)strat;
                hrStrat.setKey(keyObj, store, newRow);
            } else if (keyObj instanceof PersistenceCapable) {
                OpenJPAStateManager keysm = RelationStrategies.getStateManager(entry.getKey(), ctx);
                ValueMapping key = fm.getKeyMapping();
                if (keysm != null) {
                    key.setForeignKey(newRow, keysm);
                } else {
                    key.setForeignKey(newRow, null);
                }
            }
            rm.flushSecondaryRow(newRow);
            found = true;
        }
        return found;
    }

    private FieldMapping getFieldMapping(ClassMapping meta) {
        FieldMapping[] fields = meta.getFieldMappings();
        for (int i = 0; i < fields.length; ++i) {
            ValueMapping val = fields[i].getValueMapping();
            if (fields[i].getMappedByMetaData() != this.field || val.getDeclaredTypeCode() != 13) continue;
            return fields[i];
        }
        return null;
    }
}

