/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface CacheStatistics
extends Serializable {
    public long getReadCount();

    public long getHitCount();

    public long getWriteCount();

    public long getTotalReadCount();

    public long getTotalHitCount();

    public long getTotalWriteCount();

    public long getReadCount(Class var1);

    public long getHitCount(Class var1);

    public long getWriteCount(Class var1);

    public long getTotalReadCount(Class var1);

    public long getTotalHitCount(Class var1);

    public long getTotalWriteCount(Class var1);

    public Date since();

    public Date start();

    public void reset();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Default
    implements CacheStatistics {
        private long[] astat = new long[3];
        private long[] stat = new long[3];
        private Map<Class, long[]> stats = new HashMap<Class, long[]>();
        private Map<Class, long[]> astats = new HashMap<Class, long[]>();
        private Date start = new Date();
        private Date since = new Date();
        private static final int READ = 0;
        private static final int HIT = 1;
        private static final int WRITE = 2;

        @Override
        public long getReadCount() {
            return this.stat[0];
        }

        @Override
        public long getHitCount() {
            return this.stat[1];
        }

        @Override
        public long getWriteCount() {
            return this.stat[2];
        }

        @Override
        public long getTotalReadCount() {
            return this.astat[0];
        }

        @Override
        public long getTotalHitCount() {
            return this.astat[1];
        }

        @Override
        public long getTotalWriteCount() {
            return this.astat[2];
        }

        @Override
        public long getReadCount(Class c) {
            return this.getCount(this.stats, c, 0);
        }

        @Override
        public long getHitCount(Class c) {
            return this.getCount(this.stats, c, 1);
        }

        @Override
        public long getWriteCount(Class c) {
            return this.getCount(this.stats, c, 2);
        }

        @Override
        public long getTotalReadCount(Class c) {
            return this.getCount(this.astats, c, 0);
        }

        @Override
        public long getTotalHitCount(Class c) {
            return this.getCount(this.astats, c, 1);
        }

        @Override
        public long getTotalWriteCount(Class c) {
            return this.getCount(this.astats, c, 2);
        }

        private long getCount(Map<Class, long[]> target, Class c, int index) {
            long[] row = target.get(c);
            return row == null ? 0L : row[index];
        }

        @Override
        public Date since() {
            return this.since;
        }

        @Override
        public Date start() {
            return this.start;
        }

        @Override
        public void reset() {
            this.stat = new long[3];
            this.stats.clear();
            this.since = new Date();
        }

        void newGet(Class cls, boolean hit) {
            cls = cls == null ? Object.class : cls;
            this.addSample(cls, 0);
            if (hit) {
                this.addSample(cls, 1);
            }
        }

        void newPut(Class cls) {
            cls = cls == null ? Object.class : cls;
            this.addSample(cls, 2);
        }

        private void addSample(Class c, int index) {
            int n = index;
            this.stat[n] = this.stat[n] + 1L;
            int n2 = index;
            this.astat[n2] = this.astat[n2] + 1L;
            this.addSample(this.stats, c, index);
            this.addSample(this.astats, c, index);
        }

        private void addSample(Map<Class, long[]> target, Class c, int index) {
            long[] row = target.get(c);
            if (row == null) {
                row = new long[3];
            }
            int n = index;
            row[n] = row[n] + 1L;
            target.put(c, row);
        }
    }
}

