/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.Caches;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.DataCacheScheduler;
import org.apache.openjpa.datacache.ExpirationEvent;
import org.apache.openjpa.datacache.ExpirationListener;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataCache
extends AbstractConcurrentEventManager
implements DataCache,
Configurable {
    protected CacheStatistics.Default stats = new CacheStatistics.Default();
    private static final BitSet EMPTY_BITSET = new BitSet(0);
    private static final Localizer s_loc = Localizer.forPackage(AbstractDataCache.class);
    protected OpenJPAConfiguration conf;
    protected Log log;
    private String _name = null;
    private boolean _closed = false;
    private String _schedule = null;
    protected Set<String> _includedTypes;
    protected Set<String> _excludedTypes;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public String getEvictionSchedule() {
        return this._schedule;
    }

    public void setEvictionSchedule(String s) {
        this._schedule = s;
    }

    @Override
    public void initialize(DataCacheManager manager) {
        DataCacheScheduler scheduler;
        if (this._schedule != null && !"".equals(this._schedule) && (scheduler = manager.getDataCacheScheduler()) != null) {
            scheduler.scheduleEviction(this, this._schedule);
        }
    }

    public void commit(Collection additions, Collection newUpdates, Collection existingUpdates, Collection deletes) {
        this.removeAllInternal(deletes);
        this.putAllInternal(additions);
        this.putAllInternal(newUpdates);
        if (this.recacheUpdates()) {
            this.putAllInternal(existingUpdates);
        }
        if (this.log.isTraceEnabled()) {
            ArrayList<Object> addIds = new ArrayList<Object>(additions.size());
            ArrayList<Object> upIds = new ArrayList<Object>(newUpdates.size());
            ArrayList<Object> exIds = new ArrayList<Object>(existingUpdates.size());
            Iterator iter = additions.iterator();
            while (iter.hasNext()) {
                addIds.add(((DataCachePCData)iter.next()).getId());
            }
            iter = newUpdates.iterator();
            while (iter.hasNext()) {
                upIds.add(((DataCachePCData)iter.next()).getId());
            }
            iter = existingUpdates.iterator();
            while (iter.hasNext()) {
                exIds.add(((DataCachePCData)iter.next()).getId());
            }
            this.log.trace(s_loc.get("cache-commit", new Object[]{addIds, upIds, exIds, deletes}));
        }
    }

    @Override
    public boolean contains(Object key) {
        DataCachePCData o = this.getInternal(key);
        this.stats.newGet(o == null ? null : o.getType(), o != null);
        if (o != null && o.isTimedOut()) {
            o = null;
            this.removeInternal(key);
            if (this.log.isTraceEnabled()) {
                this.log.trace(s_loc.get("cache-timeout", key));
            }
        }
        return o != null;
    }

    public BitSet containsAll(Collection keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public DataCachePCData get(Object key) {
        DataCachePCData o = this.getInternal(key);
        if (o != null && o.isTimedOut()) {
            o = null;
            this.removeInternal(key);
            if (this.log.isTraceEnabled()) {
                this.log.trace(s_loc.get("cache-timeout", key));
            }
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace(s_loc.get("cache-miss", key));
            } else {
                this.log.trace(s_loc.get("cache-hit", key));
            }
        }
        this.stats.newGet(o == null ? null : o.getType(), o != null);
        return o;
    }

    public Map getAll(List keys) {
        HashMap resultMap = new HashMap(keys.size());
        for (Object key : keys) {
            resultMap.put(key, this.get(key));
        }
        return resultMap;
    }

    @Override
    public DataCachePCData put(DataCachePCData data) {
        this.stats.newPut(data.getType());
        DataCachePCData o = this.putInternal(data.getId(), data);
        if (this.log.isTraceEnabled()) {
            this.log.trace(s_loc.get("cache-put", data.getId()));
        }
        return o == null || o.isTimedOut() ? null : o;
    }

    @Override
    public void update(DataCachePCData data) {
        if (this.recacheUpdates()) {
            this.stats.newPut(data.getType());
            this.putInternal(data.getId(), data);
        }
    }

    @Override
    public DataCachePCData remove(Object key) {
        DataCachePCData o = this.removeInternal(key);
        if (o != null && o.isTimedOut()) {
            o = null;
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace(s_loc.get("cache-remove-miss", key));
            } else {
                this.log.trace(s_loc.get("cache-remove-hit", key));
            }
        }
        return o;
    }

    public BitSet removeAll(Collection keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.remove(iter.next()) != null) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    public void removeAll(Class cls, boolean subClasses) {
        this.removeAllInternal(cls, subClasses);
    }

    @Override
    public boolean pin(Object key) {
        boolean bool = this.pinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace(s_loc.get("cache-pin-hit", key));
            } else {
                this.log.trace(s_loc.get("cache-pin-miss", key));
            }
        }
        return bool;
    }

    public BitSet pinAll(Collection keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.pin(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public void pinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(s_loc.get("cache-class-pin", this.getName()));
        }
    }

    @Override
    public boolean unpin(Object key) {
        boolean bool = this.unpinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace(s_loc.get("cache-unpin-hit", key));
            } else {
                this.log.trace(s_loc.get("cache-unpin-miss", key));
            }
        }
        return bool;
    }

    public BitSet unpinAll(Collection keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.unpin(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public void unpinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(s_loc.get("cache-class-unpin", this.getName()));
        }
    }

    @Override
    public void clear() {
        this.clearInternal();
        if (this.log.isTraceEnabled()) {
            this.log.trace(s_loc.get("cache-clear", this.getName()));
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    protected void close(boolean clear) {
        if (!this._closed) {
            if (clear) {
                this.clearInternal();
            }
            this._closed = true;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void addExpirationListener(ExpirationListener listen) {
        this.addListener(listen);
    }

    @Override
    public boolean removeExpirationListener(ExpirationListener listen) {
        return this.removeListener(listen);
    }

    public String toString() {
        return "[" + super.toString() + ":" + this._name + "]";
    }

    public void afterCommit(RemoteCommitEvent event) {
        if (this._closed) {
            return;
        }
        if (event.getPayloadType() == 2) {
            this.removeAllTypeNamesInternal(event.getUpdatedTypeNames());
            this.removeAllTypeNamesInternal(event.getDeletedTypeNames());
        } else {
            this.removeAllInternal(event.getUpdatedObjectIds());
            this.removeAllInternal(event.getDeletedObjectIds());
        }
    }

    protected void keyRemoved(Object key, boolean expired) {
        if (this.hasListeners()) {
            this.fireEvent(new ExpirationEvent(this, key, expired));
        }
        if (expired && this.log.isTraceEnabled()) {
            this.log.trace(s_loc.get("cache-expired", key));
        }
    }

    protected boolean recacheUpdates() {
        return false;
    }

    protected abstract DataCachePCData getInternal(Object var1);

    protected abstract DataCachePCData putInternal(Object var1, DataCachePCData var2);

    protected void putAllInternal(Collection pcs) {
        for (DataCachePCData pc : pcs) {
            this.stats.newPut(pc.getType());
            this.putInternal(pc.getId(), pc);
        }
    }

    protected abstract DataCachePCData removeInternal(Object var1);

    protected abstract void removeAllInternal(Class<?> var1, boolean var2);

    protected void removeAllInternal(Collection oids) {
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.removeInternal(iter.next());
        }
    }

    protected void removeAllTypeNamesInternal(Collection classNames) {
        Set classes = Caches.addTypesByName(this.conf, classNames, null);
        if (classes == null) {
            return;
        }
        for (Class cls : classes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(s_loc.get("cache-removeclass", cls.getName()));
            }
            this.removeAllInternal(cls, false);
        }
    }

    protected abstract void clearInternal();

    protected abstract boolean pinInternal(Object var1);

    protected abstract boolean unpinInternal(Object var1);

    @Override
    public CacheStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = (OpenJPAConfiguration)conf;
        this.log = conf.getLog("openjpa.DataCache");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        if (this._name == null) {
            this.setName("default");
        }
    }

    @Override
    protected void fireEvent(Object event, Object listener) {
        block2: {
            ExpirationListener listen = (ExpirationListener)listener;
            ExpirationEvent ev = (ExpirationEvent)event;
            try {
                listen.onExpire(ev);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block2;
                this.log.warn(s_loc.get("exp-listener-ex"), e);
            }
        }
    }

    public Set<String> getTypes() {
        return this._includedTypes;
    }

    public Set<String> getExcludedTypes() {
        return this._excludedTypes;
    }

    public void setTypes(Set<String> types) {
        this._includedTypes = types;
    }

    public void setTypes(String types) {
        this._includedTypes = StringUtils.isEmpty(types) ? null : new HashSet<String>(Arrays.asList(Strings.split(types, ";", 0)));
    }

    public void setExcludedTypes(Set<String> types) {
        this._excludedTypes = types;
    }

    public void setExcludedTypes(String types) {
        this._excludedTypes = StringUtils.isEmpty(types) ? null : new HashSet<String>(Arrays.asList(Strings.split(types, ";", 0)));
    }
}

