/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.extensions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.MetaBeanManager;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.BeanDescriptorImpl;
import org.apache.bval.jsr303.ClassValidator;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.Jsr303MetaBeanFactory;
import org.apache.bval.jsr303.extensions.ConstructorDescriptorImpl;
import org.apache.bval.jsr303.extensions.MethodBeanDescriptorImpl;
import org.apache.bval.jsr303.extensions.MethodDescriptorImpl;
import org.apache.bval.jsr303.extensions.MethodValidator;
import org.apache.bval.jsr303.extensions.MethodValidatorMetaBeanFactory;
import org.apache.bval.jsr303.extensions.ParameterDescriptor;
import org.apache.bval.jsr303.extensions.ParameterDescriptorImpl;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.model.MetaBean;
import org.apache.bval.util.ValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodValidatorImpl
extends ClassValidator
implements MethodValidator {
    public MethodValidatorImpl(ApacheFactoryContext factoryContext) {
        super(factoryContext);
        this.patchFactoryContextForMethodValidation(factoryContext);
    }

    private void patchFactoryContextForMethodValidation(ApacheFactoryContext factoryContext) {
        MetaBeanFactory[] factories = ((MetaBeanManager)this.getMetaBeanFinder()).getBuilder().getFactories();
        for (int i = 0; i < factories.length; ++i) {
            if (!(factories[i] instanceof Jsr303MetaBeanFactory) || factories[i] instanceof MethodValidatorMetaBeanFactory) continue;
            factories[i] = new MethodValidatorMetaBeanFactory(factoryContext);
        }
    }

    @Override
    protected BeanDescriptorImpl createBeanDescriptor(MetaBean metaBean) {
        MethodBeanDescriptorImpl descriptor = new MethodBeanDescriptorImpl(this.factoryContext, metaBean);
        MethodValidatorMetaBeanFactory factory = new MethodValidatorMetaBeanFactory(this.factoryContext);
        factory.buildMethodDescriptor(descriptor);
        return descriptor;
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameters(Class<T> clazz, Method method, Object[] parameters, Class<?> ... groupArray) {
        MethodBeanDescriptorImpl beanDesc = (MethodBeanDescriptorImpl)this.getConstraintsForClass(clazz);
        MethodDescriptorImpl methodDescriptor = (MethodDescriptorImpl)beanDesc.getConstraintsForMethod(method);
        if (methodDescriptor == null) {
            throw new ValidationException("Method " + method + " doesn't belong to class " + clazz);
        }
        return this.validateParameters(methodDescriptor.getMetaBean(), methodDescriptor.getParameterDescriptors(), parameters, groupArray);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameter(Class<T> clazz, Method method, Object parameter, int parameterIndex, Class<?> ... groupArray) {
        MethodBeanDescriptorImpl beanDesc = (MethodBeanDescriptorImpl)this.getConstraintsForClass(clazz);
        MethodDescriptorImpl methodDescriptor = (MethodDescriptorImpl)beanDesc.getConstraintsForMethod(method);
        if (methodDescriptor == null) {
            throw new ValidationException("Method " + method + " doesn't belong to class " + clazz);
        }
        ParameterDescriptorImpl paramDesc = (ParameterDescriptorImpl)methodDescriptor.getParameterDescriptors().get(parameterIndex);
        return this.validateParameter(paramDesc, parameter, groupArray);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameters(Class<T> clazz, Constructor<T> constructor, Object[] parameters, Class<?> ... groupArray) {
        MethodBeanDescriptorImpl beanDesc = (MethodBeanDescriptorImpl)this.getConstraintsForClass(clazz);
        ConstructorDescriptorImpl constructorDescriptor = (ConstructorDescriptorImpl)beanDesc.getConstraintsForConstructor(constructor);
        if (constructorDescriptor == null) {
            throw new ValidationException("Constructor " + constructor + " doesn't belong to class " + clazz);
        }
        return this.validateParameters(constructorDescriptor.getMetaBean(), constructorDescriptor.getParameterDescriptors(), parameters, groupArray);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameter(Class<T> clazz, Constructor<T> constructor, Object parameter, int parameterIndex, Class<?> ... groupArray) {
        MethodBeanDescriptorImpl beanDesc = (MethodBeanDescriptorImpl)this.getConstraintsForClass(clazz);
        ConstructorDescriptorImpl constructorDescriptor = (ConstructorDescriptorImpl)beanDesc.getConstraintsForConstructor(constructor);
        if (constructorDescriptor == null) {
            throw new ValidationException("Constructor " + constructor + " doesn't belong to class " + clazz);
        }
        ParameterDescriptorImpl paramDesc = (ParameterDescriptorImpl)constructorDescriptor.getParameterDescriptors().get(parameterIndex);
        return this.validateParameter(paramDesc, parameter, groupArray);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateReturnedValue(Class<T> clazz, Method method, Object returnedValue, Class<?> ... groupArray) {
        MethodBeanDescriptorImpl beanDesc = (MethodBeanDescriptorImpl)this.getConstraintsForClass(clazz);
        MethodDescriptorImpl methodDescriptor = (MethodDescriptorImpl)beanDesc.getConstraintsForMethod(method);
        if (methodDescriptor == null) {
            throw new ValidationException("Method " + method + " doesn't belong to class " + clazz);
        }
        GroupValidationContext<Object> context = this.createContext(methodDescriptor.getMetaBean(), returnedValue, null, groupArray);
        this.validateReturnedValueInContext(context, methodDescriptor);
        ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
        return result.getConstraintViolations();
    }

    private <T> Set<ConstraintViolation<T>> validateParameters(MetaBean metaBean, List<ParameterDescriptor> paramDescriptors, Object[] parameters, Class<?> ... groupArray) {
        if (parameters == null) {
            throw new IllegalArgumentException("cannot validate null");
        }
        if (parameters.length > 0) {
            try {
                GroupValidationContext<Object> context = this.createContext(metaBean, null, null, groupArray);
                for (int i = 0; i < parameters.length; ++i) {
                    ParameterDescriptorImpl paramDesc = (ParameterDescriptorImpl)paramDescriptors.get(i);
                    context.setBean(parameters[i]);
                    this.validateParameterInContext(context, paramDesc);
                }
                ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
                return result.getConstraintViolations();
            }
            catch (RuntimeException ex) {
                throw MethodValidatorImpl.unrecoverableValidationError(ex, parameters);
            }
        }
        return Collections.emptySet();
    }

    private <T> Set<ConstraintViolation<T>> validateParameter(ParameterDescriptorImpl paramDesc, Object parameter, Class<?> ... groupArray) {
        try {
            GroupValidationContext<Object> context = this.createContext(paramDesc.getMetaBean(), parameter, null, groupArray);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            this.validateParameterInContext(context, paramDesc);
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw MethodValidatorImpl.unrecoverableValidationError(ex, parameter);
        }
    }

    private <T> void validateParameterInContext(GroupValidationContext<T> context, ParameterDescriptorImpl paramDesc) {
        Groups groups = context.getGroups();
        for (ConstraintDescriptor<?> constraintDescriptor : paramDesc.getConstraintDescriptors()) {
            ConstraintValidation validation = (ConstraintValidation)constraintDescriptor;
            for (Group group : groups.getGroups()) {
                context.setCurrentGroup(group);
                validation.validate(context);
            }
            block2: for (List list : groups.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    validation.validate(context);
                    if (((ConstraintValidationListener)context.getListener()).isEmpty()) continue;
                    continue block2;
                }
            }
        }
        if (paramDesc.isCascaded() && context.getValidatedValue() != null) {
            context.setMetaBean(this.factoryContext.getMetaBeanFinder().findForClass(context.getValidatedValue().getClass()));
            for (Group group : groups.getGroups()) {
                context.setCurrentGroup(group);
                ValidationHelper.validateContext(context, (ValidationHelper.ValidateCallback)new ClassValidator.Jsr303ValidationCallback(this, context), (boolean)this.isTreatMapsLikeBeans());
            }
            block5: for (List list : groups.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    ValidationHelper.validateContext(context, (ValidationHelper.ValidateCallback)new ClassValidator.Jsr303ValidationCallback(this, context), (boolean)this.isTreatMapsLikeBeans());
                    if (((ConstraintValidationListener)context.getListener()).isEmpty()) continue;
                    continue block5;
                }
            }
        }
    }

    private <T> void validateReturnedValueInContext(GroupValidationContext<T> context, MethodDescriptorImpl methodDescriptor) {
        Groups groups = context.getGroups();
        for (ConstraintDescriptor<?> constraintDescriptor : methodDescriptor.getConstraintDescriptors()) {
            ConstraintValidation validation = (ConstraintValidation)constraintDescriptor;
            for (Group group : groups.getGroups()) {
                context.setCurrentGroup(group);
                validation.validate(context);
            }
            block2: for (List list : groups.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    validation.validate(context);
                    if (((ConstraintValidationListener)context.getListener()).isEmpty()) continue;
                    continue block2;
                }
            }
        }
        if (methodDescriptor.isCascaded() && context.getValidatedValue() != null) {
            context.setMetaBean(this.factoryContext.getMetaBeanFinder().findForClass(context.getValidatedValue().getClass()));
            for (Group group : groups.getGroups()) {
                context.setCurrentGroup(group);
                ValidationHelper.validateContext(context, (ValidationHelper.ValidateCallback)new ClassValidator.Jsr303ValidationCallback(this, context), (boolean)this.isTreatMapsLikeBeans());
            }
            block5: for (List list : groups.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    ValidationHelper.validateContext(context, (ValidationHelper.ValidateCallback)new ClassValidator.Jsr303ValidationCallback(this, context), (boolean)this.isTreatMapsLikeBeans());
                    if (((ConstraintValidationListener)context.getListener()).isEmpty()) continue;
                    continue block5;
                }
            }
        }
    }
}

