/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.openejb.config.Deployment;
import org.apache.openejb.config.DeploymentException;

public class OpenEJBDeploymentManager
implements DeploymentManager {
    public static final DConfigBeanVersionType DEFAULT_DCONFIG_BEAN_VERSION = DConfigBeanVersionType.V1_4;
    public static final String DEFAULT_TARGET_NAME = "DefaultTarget";
    private Deployment deployment;
    private final Locale locale;
    private final DConfigBeanVersionType dconfigBeanVersion;
    private final Target defaultTarget;
    private final SortedMap<String, Target> targets;
    private final List<String> targetPaths;

    public OpenEJBDeploymentManager() {
        this.locale = Locale.getDefault();
        this.dconfigBeanVersion = DEFAULT_DCONFIG_BEAN_VERSION;
        this.defaultTarget = null;
        this.targets = null;
        this.targetPaths = null;
    }

    public OpenEJBDeploymentManager(Deployment deployment) throws DeploymentManagerCreationException {
        this.deployment = deployment;
        Properties properties = deployment.getProperties();
        String localeString = properties.getProperty("locale");
        this.locale = localeString != null ? new Locale(localeString) : Locale.getDefault();
        String dconfigBeanVersionString = properties.getProperty("locale");
        this.dconfigBeanVersion = OpenEJBDeploymentManager.parseDConfigBeanVersionType(dconfigBeanVersionString);
        TreeMap<String, TargetImpl> targets = new TreeMap<String, TargetImpl>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String targetName = (String)entry.getValue();
            if (!key.startsWith("target.") || key.endsWith(".description")) continue;
            String targetDescription = properties.getProperty(key + ".description");
            TargetImpl target = new TargetImpl(targetName, targetDescription);
            targets.put(targetName, target);
        }
        String defaultTargetName = properties.getProperty("target.default");
        if (defaultTargetName == null) {
            defaultTargetName = DEFAULT_TARGET_NAME;
        }
        if (!targets.containsKey(defaultTargetName)) {
            targets.put(defaultTargetName, new TargetImpl(defaultTargetName, null));
        }
        this.defaultTarget = (Target)targets.get(defaultTargetName);
        this.targets = Collections.unmodifiableSortedMap(targets);
        this.targetPaths = new ArrayList<String>();
        for (String targetName : targets.keySet()) {
            this.targetPaths.add(targetName + "/");
        }
        Collections.reverse(this.targetPaths);
    }

    @Override
    public void release() {
        if (this.deployment != null) {
            this.deployment.release();
            this.deployment = null;
        }
    }

    @Override
    public Target[] getTargets() {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        return this.targets.values().toArray(new Target[this.targets.size()]);
    }

    @Override
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            String type = null;
            if (type != null) {
                moduleType.toString();
            }
            Set<String> targetModulesStrings = this.deployment.list(type, null, this.toTargetSet(targetList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModulesStrings);
            return targetModules.toArray(new TargetModuleID[targetModules.size()]);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException("DeployerException while listing deployments", e);
        }
    }

    @Override
    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            String type = null;
            if (type != null) {
                moduleType.toString();
            }
            Set<String> targetModulesStrings = this.deployment.list(type, "stopped", this.toTargetSet(targetList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModulesStrings);
            return targetModules.toArray(new TargetModuleID[targetModules.size()]);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException("DeployerException while listing deployments", e);
        }
    }

    @Override
    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            String type = null;
            if (type != null) {
                moduleType.toString();
            }
            Set<String> targetModulesStrings = this.deployment.list(type, "running", this.toTargetSet(targetList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModulesStrings);
            return targetModules.toArray(new TargetModuleID[targetModules.size()]);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException("DeployerException while listing deployments", e);
        }
    }

    @Override
    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            Set<String> targetModuleStrings = this.deployment.deploy(this.toTargetSet(targetList), moduleArchive);
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModuleStrings);
            return new ProgressObjectImpl(CommandType.DISTRIBUTE, targetModules);
        }
        catch (DeploymentException e) {
            return new ProgressObjectImpl(CommandType.DISTRIBUTE, e);
        }
    }

    @Override
    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            Set<String> targetModuleStrings = this.deployment.deploy(this.toTargetSet(targetList), null);
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModuleStrings);
            return new ProgressObjectImpl(CommandType.DISTRIBUTE, targetModules);
        }
        catch (DeploymentException e) {
            return new ProgressObjectImpl(CommandType.DISTRIBUTE, e);
        }
    }

    @Override
    public ProgressObject start(TargetModuleID[] moduleIdList) {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            Set<String> targetModuleStrings = this.deployment.start(this.toModuleSet(moduleIdList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModuleStrings);
            return new ProgressObjectImpl(CommandType.START, targetModules);
        }
        catch (DeploymentException e) {
            return new ProgressObjectImpl(CommandType.START, e);
        }
    }

    @Override
    public ProgressObject stop(TargetModuleID[] moduleIdList) {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            Set<String> targetModuleStrings = this.deployment.stop(this.toModuleSet(moduleIdList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModuleStrings);
            return new ProgressObjectImpl(CommandType.STOP, targetModules);
        }
        catch (DeploymentException e) {
            return new ProgressObjectImpl(CommandType.STOP, e);
        }
    }

    @Override
    public ProgressObject undeploy(TargetModuleID[] moduleIdList) {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            Set<String> targetModuleStrings = this.deployment.undeploy(this.toModuleSet(moduleIdList));
            Set<TargetModuleID> targetModules = this.toTargetModuleIds(targetModuleStrings);
            return new ProgressObjectImpl(CommandType.UNDEPLOY, targetModules);
        }
        catch (DeploymentException e) {
            return new ProgressObjectImpl(CommandType.UNDEPLOY, e);
        }
    }

    @Override
    public boolean isRedeploySupported() {
        return false;
    }

    @Override
    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        throw new UnsupportedOperationException("redeploy is not supported");
    }

    @Override
    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        throw new UnsupportedOperationException("redeploy is not supported");
    }

    @Override
    public Locale[] getSupportedLocales() {
        return new Locale[]{this.getDefaultLocale()};
    }

    @Override
    public Locale getCurrentLocale() {
        return this.getDefaultLocale();
    }

    @Override
    public Locale getDefaultLocale() {
        return this.locale;
    }

    @Override
    public boolean isLocaleSupported(Locale locale) {
        return this.getDefaultLocale().equals(locale);
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.isLocaleSupported(locale)) {
            throw new UnsupportedOperationException("Unsupported locale");
        }
    }

    @Override
    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.dconfigBeanVersion;
    }

    @Override
    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return this.dconfigBeanVersion.equals(version);
    }

    @Override
    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException("Version not supported " + version);
        }
    }

    @Override
    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new InvalidModuleException("Not supported: " + deployableObject.getType());
    }

    private Target getTargetFor(String moduleId) {
        for (String targetName : this.targetPaths) {
            if (!moduleId.startsWith(moduleId)) continue;
            return (Target)this.targets.get(targetName);
        }
        return null;
    }

    private Set<TargetModuleID> toTargetModuleIds(Set<String> modules) {
        HashSet<TargetModuleID> targetModuleIds = new HashSet<TargetModuleID>();
        for (String module : modules) {
            String webUrl;
            String moduleId;
            int spaceIndex = module.indexOf(32);
            if (spaceIndex > 1) {
                moduleId = module.substring(0, spaceIndex);
                webUrl = module.substring(spaceIndex + 1);
            } else {
                moduleId = module;
                webUrl = null;
            }
            Target target = this.getTargetFor(moduleId);
            if (target != null) {
                if (moduleId.startsWith(target.getName())) {
                    moduleId = moduleId.substring(target.getName().length());
                }
            } else {
                target = this.defaultTarget;
            }
            TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl(target, moduleId, webUrl);
            targetModuleIds.add(targetModuleID);
        }
        return targetModuleIds;
    }

    private Set<String> toTargetSet(Target[] targets) {
        if (targets == null) {
            return Collections.emptySet();
        }
        TreeSet<String> targetSet = new TreeSet<String>();
        for (Target target : targets) {
            targetSet.add(target.getName());
        }
        return targetSet;
    }

    private Set<String> toModuleSet(TargetModuleID[] moduleIDList) {
        if (moduleIDList == null) {
            return Collections.emptySet();
        }
        TreeSet<String> moduleSet = new TreeSet<String>();
        for (TargetModuleID module : moduleIDList) {
            moduleSet.add(module.getTarget().getName() + "/" + module.getModuleID());
        }
        return moduleSet;
    }

    public static DConfigBeanVersionType parseDConfigBeanVersionType(String string) throws DeploymentManagerCreationException {
        if (string == null) {
            return DEFAULT_DCONFIG_BEAN_VERSION;
        }
        try {
            Field field = DConfigBeanVersionType.class.getField(string);
            if (field.getType().equals(DConfigBeanVersionType.class) && Modifier.isStatic(field.getModifiers())) {
                return (DConfigBeanVersionType)field.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new DeploymentManagerCreationException("Unknown DConfig bean version: " + string);
    }

    public static class DeploymentStatusImpl
    implements DeploymentStatus {
        private final CommandType command;
        private final StateType state;
        private final String message;

        public DeploymentStatusImpl(CommandType command) {
            this.command = command;
            this.state = StateType.COMPLETED;
            this.message = null;
        }

        public DeploymentStatusImpl(CommandType command, Exception exception) {
            this.command = command;
            this.state = StateType.FAILED;
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)writer, true));
            this.message = writer.toString();
        }

        @Override
        public CommandType getCommand() {
            return this.command;
        }

        @Override
        public ActionType getAction() {
            return ActionType.EXECUTE;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public StateType getState() {
            return this.state;
        }

        @Override
        public boolean isRunning() {
            return StateType.RUNNING.equals(this.state);
        }

        @Override
        public boolean isCompleted() {
            return StateType.COMPLETED.equals(this.state);
        }

        @Override
        public boolean isFailed() {
            return StateType.FAILED.equals(this.state);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DeploymentStatus[").append(this.command).append(',');
            buf.append(this.state);
            if (this.message != null) {
                buf.append(',').append(this.message);
            }
            buf.append(']');
            return buf.toString();
        }
    }

    public class ProgressObjectImpl
    implements ProgressObject {
        private final Set<TargetModuleID> targetModuleIds;
        private final ProgressEvent event;
        private final DeploymentStatus deploymentStatus;

        public ProgressObjectImpl(CommandType command, Set<TargetModuleID> targetModuleIds) {
            this.targetModuleIds = targetModuleIds;
            this.deploymentStatus = new DeploymentStatusImpl(command);
            this.event = new ProgressEvent(this, null, this.deploymentStatus);
        }

        public ProgressObjectImpl(CommandType command, Exception exception) {
            this.targetModuleIds = null;
            this.deploymentStatus = new DeploymentStatusImpl(command, exception);
            this.event = new ProgressEvent(this, null, this.deploymentStatus);
        }

        @Override
        public synchronized TargetModuleID[] getResultTargetModuleIDs() {
            return this.targetModuleIds.toArray(new TargetModuleID[this.targetModuleIds.size()]);
        }

        @Override
        public synchronized DeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public ClientConfiguration getClientConfiguration(TargetModuleID id) {
            return null;
        }

        @Override
        public boolean isCancelSupported() {
            return false;
        }

        @Override
        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("cancel is not supported");
        }

        @Override
        public boolean isStopSupported() {
            return false;
        }

        @Override
        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("stop is not supported");
        }

        @Override
        public void addProgressListener(ProgressListener pol) {
            pol.handleProgressEvent(this.event);
        }

        @Override
        public void removeProgressListener(ProgressListener pol) {
        }
    }

    public static class TargetModuleIDImpl
    implements TargetModuleID,
    Comparable,
    Serializable {
        private static final long serialVersionUID = 2471961579457311472L;
        private final Target target;
        private final String moduleId;
        private final String webUrl;
        private TargetModuleID parentTargetModuleId;
        private Set<TargetModuleID> children = new TreeSet<TargetModuleID>();

        public TargetModuleIDImpl(Target target, String moduleId) {
            this(target, moduleId, null);
        }

        public TargetModuleIDImpl(Target target, String moduleId, String webUrl) {
            if (target == null) {
                throw new NullPointerException("target is null");
            }
            if (moduleId == null) {
                throw new NullPointerException("moduleId is null");
            }
            this.target = target;
            this.moduleId = moduleId;
            this.webUrl = webUrl;
        }

        @Override
        public Target getTarget() {
            return this.target;
        }

        @Override
        public String getModuleID() {
            return this.moduleId;
        }

        @Override
        public TargetModuleID getParentTargetModuleID() {
            return this.parentTargetModuleId;
        }

        public void setParentTargetModuleID(TargetModuleIDImpl parentTargetModuleId) {
            this.parentTargetModuleId = parentTargetModuleId;
            parentTargetModuleId.children.add(this);
        }

        @Override
        public TargetModuleID[] getChildTargetModuleID() {
            return this.children.toArray(new TargetModuleID[this.children.size()]);
        }

        @Override
        public String getWebURL() {
            return this.webUrl;
        }

        @Override
        public String toString() {
            return this.target + "/" + this.moduleId + (this.webUrl == null ? " " : this.webUrl);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetModuleIDImpl)) {
                return false;
            }
            TargetModuleIDImpl targetModuleID = (TargetModuleIDImpl)o;
            return this.target.equals(targetModuleID.target) && this.moduleId.equals(targetModuleID.moduleId);
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = 29 * result + this.moduleId.hashCode();
            return result;
        }

        public int compareTo(Object o) {
            TargetModuleIDImpl targetModuleID = (TargetModuleIDImpl)o;
            int val = this.target.getName().compareTo(targetModuleID.target.getName());
            if (val != 0) {
                return val;
            }
            return this.moduleId.compareTo(targetModuleID.moduleId);
        }
    }

    public static class TargetImpl
    implements Target,
    Comparable,
    Serializable {
        private static final long serialVersionUID = -7257857314911948377L;
        private final String name;
        private final String description;

        public TargetImpl(String name) {
            this(name, null);
        }

        public TargetImpl(String name, String description) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetImpl)) {
                return false;
            }
            TargetImpl target = (TargetImpl)o;
            return this.name.equals(target.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public int compareTo(Object o) {
            TargetImpl target = (TargetImpl)o;
            return this.name.compareTo(target.name);
        }
    }
}

