/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.sun;

import javax.xml.bind.annotation.XmlRegistry;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the org.apache.openejb.jee.sun package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 */
@XmlRegistry
public class ObjectFactory {


    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.apache.openejb.jee.sun
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link CmpFieldMapping }
     */
    public CmpFieldMapping createCmpFieldMapping() {
        return new CmpFieldMapping();
    }

    /**
     * Create an instance of {@link ColumnPair }
     */
    public ColumnPair createColumnPair() {
        return new ColumnPair();
    }

    /**
     * Create an instance of {@link EntityMapping }
     */
    public EntityMapping createEntityMapping() {
        return new EntityMapping();
    }

    /**
     * Create an instance of {@link NamedGroup }
     */
    public NamedGroup createNamedGroup() {
        return new NamedGroup();
    }

    /**
     * Create an instance of {@link CheckVersionOfAccessedInstances }
     */
    public CheckVersionOfAccessedInstances createCheckVersionOfAccessedInstances() {
        return new CheckVersionOfAccessedInstances();
    }

    /**
     * Create an instance of {@link LockWhenModified }
     */
    public LockWhenModified createLockWhenModified() {
        return new LockWhenModified();
    }

    /**
     * Create an instance of {@link SecondaryTable }
     */
    public SecondaryTable createSecondaryTable() {
        return new SecondaryTable();
    }

    /**
     * Create an instance of {@link Level }
     */
    public Level createLevel() {
        return new Level();
    }

    /**
     * Create an instance of {@link CheckModifiedAtCommit }
     */
    public CheckModifiedAtCommit createCheckModifiedAtCommit() {
        return new CheckModifiedAtCommit();
    }

    /**
     * Create an instance of {@link Consistency }
     */
    public Consistency createConsistency() {
        return new Consistency();
    }

    /**
     * Create an instance of {@link ReadOnly }
     */
    public ReadOnly createReadOnly() {
        return new ReadOnly();
    }

    /**
     * Create an instance of {@link LockWhenLoaded }
     */
    public LockWhenLoaded createLockWhenLoaded() {
        return new LockWhenLoaded();
    }

    /**
     * Create an instance of {@link Default }
     */
    public Default createDefault() {
        return new Default();
    }

    /**
     * Create an instance of {@link CheckAllAtCommit }
     */
    public CheckAllAtCommit createCheckAllAtCommit() {
        return new CheckAllAtCommit();
    }

    /**
     * Create an instance of {@link SunCmpMapping }
     */
    public SunCmpMapping createSunCmpMapping() {
        return new SunCmpMapping();
    }

    /**
     * Create an instance of {@link SunEjbJar }
     */
    public SunEjbJar createSunEjbJar() {
        return new SunEjbJar();
    }

    /**
     * Create an instance of {@link None }
     */
    public None createNone() {
        return new None();
    }

    /**
     * Create an instance of {@link CmrFieldMapping }
     */
    public CmrFieldMapping createCmrFieldMapping() {
        return new CmrFieldMapping();
    }

    /**
     * Create an instance of {@link FetchedWith }
     */
    public FetchedWith createFetchedWith() {
        return new FetchedWith();
    }

    /**
     * Create an instance of {@link ColumnName }
     */
    public ColumnName createColumnName() {
        return new ColumnName();
    }

    /**
     * Create an instance of {@link SunCmpMappings }
     */
    public SunCmpMappings createSunCmpMappings() {
        return new SunCmpMappings();
    }

}
