/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import javax.security.auth.login.FailedLoginException;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.IdentityResolver;
import org.apache.openejb.client.JaasIdentityResolver;
import org.apache.openejb.client.ResourceFinder;
import org.apache.openejb.client.ServerMetaData;

public class ClientSecurity {
    public static final String IDENTITY_RESOLVER_STRATEGY = "openejb.client.identityResolver";
    private static ServerMetaData server;
    private static IdentityResolver identityResolver;
    private static Object staticClientIdentity;
    private static final InheritableThreadLocal<Object> threadClientIdentity;

    public static ServerMetaData getServer() {
        return server;
    }

    public static void setServer(ServerMetaData server) {
        ClientSecurity.server = server;
    }

    public static void login(String username, String password) throws FailedLoginException {
        ClientSecurity.login(username, password, false);
    }

    public static void login(String username, String password, boolean threadScoped) throws FailedLoginException {
        Object clientIdentity = ClientSecurity.directAuthentication(username, password, server);
        if (threadScoped) {
            threadClientIdentity.set(clientIdentity);
        } else {
            staticClientIdentity = clientIdentity;
        }
        identityResolver = new SimpleIdentityResolver();
    }

    public static void logout() {
        threadClientIdentity.set(null);
        staticClientIdentity = null;
    }

    public static Object directAuthentication(String username, String password, ServerMetaData server) throws FailedLoginException {
        return ClientSecurity.directAuthentication(null, username, password, server);
    }

    public static Object directAuthentication(String securityRealm, String username, String password, ServerMetaData server) throws FailedLoginException {
        AuthenticationResponse authRes;
        AuthenticationRequest authReq = new AuthenticationRequest(securityRealm, username, password);
        try {
            authRes = (AuthenticationResponse)Client.request(authReq, new AuthenticationResponse(), server);
        }
        catch (RemoteException e) {
            throw (FailedLoginException)new FailedLoginException("Unable to authenticate with server " + server).initCause(e);
        }
        if (authRes.getResponseCode() != 1) {
            throw (FailedLoginException)new FailedLoginException("This principal is not authenticated.").initCause(authRes.getDeniedCause());
        }
        return authRes.getIdentity().getClientIdentity();
    }

    public static Object getIdentity() {
        return ClientSecurity.getIdentityResolver().getIdentity();
    }

    public static IdentityResolver getIdentityResolver() {
        if (identityResolver == null) {
            String strategy = System.getProperty(IDENTITY_RESOLVER_STRATEGY);
            if (strategy == null) {
                identityResolver = new JaasIdentityResolver();
            } else {
                Class identityResolverClass;
                ResourceFinder finder = new ResourceFinder("META-INF/");
                try {
                    identityResolverClass = finder.findClass(IdentityResolver.class.getName() + "/" + strategy);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not find client identity strategy '" + strategy + "'");
                }
                if (!IdentityResolver.class.isAssignableFrom(identityResolverClass)) {
                    throw new IllegalArgumentException("Client identity strategy '" + strategy + "' " + "class '" + identityResolverClass.getName() + "' does not implement the " + "interface '" + IdentityResolver.class.getSimpleName() + "'");
                }
                try {
                    identityResolver = (IdentityResolver)identityResolverClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create client identity strategy '" + strategy + "' " + "class '" + identityResolverClass.getName() + "'", e);
                }
            }
        }
        return identityResolver;
    }

    public static void setIdentityResolver(IdentityResolver identityResolver) {
        ClientSecurity.identityResolver = identityResolver;
    }

    private ClientSecurity() {
    }

    static {
        block5: {
            threadClientIdentity = new InheritableThreadLocal();
            String serverUri = System.getProperty("openejb.server.uri");
            if (serverUri != null) {
                try {
                    URI location = new URI(serverUri);
                    server = new ServerMetaData(location);
                }
                catch (Exception e) {
                    if (serverUri.contains("://")) break block5;
                    try {
                        URI location = new URI("oejb://" + serverUri);
                        server = new ServerMetaData(location);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class SimpleIdentityResolver
    implements IdentityResolver {
        @Override
        public Object getIdentity() {
            Object clientIdentity = threadClientIdentity.get();
            if (clientIdentity == null) {
                clientIdentity = staticClientIdentity;
            }
            return clientIdentity;
        }
    }
}

