/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessListener;
import org.apache.maven.surefire.booter.MasterProcessReader;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testng.utils.FailFastEventsSingleton;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.TestsToRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGProvider
extends AbstractProvider {
    private final Map<String, String> providerProperties;
    private final ReporterConfiguration reporterConfiguration;
    private final ClassLoader testClassLoader;
    private final ScanResult scanResult;
    private final TestRequest testRequest;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final List<CommandLineOption> mainCliOptions;
    private final MasterProcessReader commandsReader;
    private TestsToRun testsToRun;

    public TestNGProvider(ProviderParameters booterParameters) {
        this.commandsReader = booterParameters.isInsideFork() ? MasterProcessReader.getReader().setShutdown(booterParameters.getShutdown()) : null;
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.providerProperties = booterParameters.getProviderProperties();
        this.testRequest = booterParameters.getTestRequest();
        this.reporterConfiguration = booterParameters.getReporterConfiguration();
        this.scanResult = booterParameters.getScanResult();
        this.mainCliOptions = booterParameters.getMainCliOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        try {
            if (this.isFailFast() && this.commandsReader != null) {
                this.registerPleaseStopListener();
            }
            if (this.commandsReader != null) {
                this.commandsReader.awaitStarted();
            }
            ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
            if (this.isTestNGXmlTestSuite(this.testRequest)) {
                TestNGXmlTestSuite testNGXmlTestSuite = this.newXmlSuite();
                testNGXmlTestSuite.locateTestSets(this.testClassLoader);
                if (forkTestSet != null && this.testRequest == null) {
                    testNGXmlTestSuite.execute((String)forkTestSet, reporterFactory);
                } else {
                    testNGXmlTestSuite.execute(reporterFactory);
                }
            } else {
                if (this.testsToRun == null) {
                    this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
                }
                if (this.commandsReader != null) {
                    this.commandsReader.addShutdownListener(new MasterProcessListener(){

                        public void update(Command command) {
                            TestNGProvider.this.testsToRun.markTestSetFinished();
                        }
                    });
                }
                TestNGDirectoryTestSuite suite = this.newDirectorySuite();
                suite.execute(this.testsToRun, reporterFactory);
            }
            RunResult runResult = reporterFactory.close();
            return runResult;
        }
        finally {
            this.closeCommandsReader();
        }
    }

    boolean isTestNGXmlTestSuite(TestRequest testSuiteDefinition) {
        List suiteXmlFiles = testSuiteDefinition.getSuiteXmlFiles();
        return suiteXmlFiles != null && !suiteXmlFiles.isEmpty() && !this.hasSpecificTests();
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void closeCommandsReader() {
        if (this.commandsReader != null) {
            this.commandsReader.stop();
        }
    }

    private MasterProcessListener registerPleaseStopListener() {
        MasterProcessListener listener = new MasterProcessListener(){

            public void update(Command command) {
                FailFastEventsSingleton.getInstance().setSkipOnNextTest();
            }
        };
        this.commandsReader.addSkipNextListener(listener);
        return listener;
    }

    private TestNGDirectoryTestSuite newDirectorySuite() {
        return new TestNGDirectoryTestSuite(this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.createMethodFilter(), this.runOrderCalculator, this.scanResult, this.mainCliOptions, this.getSkipAfterFailureCount());
    }

    private TestNGXmlTestSuite newXmlSuite() {
        return new TestNGXmlTestSuite(this.testRequest.getSuiteXmlFiles(), this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.getSkipAfterFailureCount());
    }

    public Iterable<Class<?>> getSuites() {
        if (this.isTestNGXmlTestSuite(this.testRequest)) {
            try {
                return this.newXmlSuite().locateTestSets(this.testClassLoader).keySet();
            }
            catch (TestSetFailedException e) {
                throw new RuntimeException(e);
            }
        }
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(null, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private boolean hasSpecificTests() {
        TestListResolver tests = this.testRequest.getTestListResolver();
        return tests != null && !tests.isEmpty();
    }

    private TestListResolver createMethodFilter() {
        TestListResolver tests = this.testRequest.getTestListResolver();
        return tests == null ? null : tests.createMethodFilters();
    }
}

