/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.surefire.JdkAttributes;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.util.Relocator;
import org.apache.maven.surefire.api.util.internal.ImmutableMap;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.extensions.ForkNodeFactory;

public abstract class DefaultForkConfiguration
extends ForkConfiguration {
    @Nonnull
    private final Classpath booterClasspath;
    @Nonnull
    private final File tempDirectory;
    @Nullable
    private final String debugLine;
    @Nonnull
    private final File workingDirectory;
    @Nonnull
    private final Properties modelProperties;
    @Nullable
    private final String argLine;
    @Nonnull
    private final Map<String, String> environmentVariables;
    @Nonnull
    private final String[] excludedEnvironmentVariables;
    private final boolean debug;
    private final int forkCount;
    private final boolean reuseForks;
    @Nonnull
    private final Platform pluginPlatform;
    @Nonnull
    private final ConsoleLogger log;
    @Nonnull
    private final ForkNodeFactory forkNodeFactory;

    protected DefaultForkConfiguration(@Nonnull Classpath booterClasspath, @Nonnull File tempDirectory, @Nullable String debugLine, @Nonnull File workingDirectory, @Nonnull Properties modelProperties, @Nullable String argLine, @Nonnull Map<String, String> environmentVariables, @Nonnull String[] excludedEnvironmentVariables, boolean debug, int forkCount, boolean reuseForks, @Nonnull Platform pluginPlatform, @Nonnull ConsoleLogger log, @Nonnull ForkNodeFactory forkNodeFactory) {
        this.booterClasspath = booterClasspath;
        this.tempDirectory = tempDirectory;
        this.debugLine = debugLine;
        this.workingDirectory = workingDirectory;
        this.modelProperties = modelProperties;
        this.argLine = argLine;
        this.environmentVariables = DefaultForkConfiguration.toImmutable(environmentVariables);
        this.excludedEnvironmentVariables = excludedEnvironmentVariables;
        this.debug = debug;
        this.forkCount = forkCount;
        this.reuseForks = reuseForks;
        this.pluginPlatform = pluginPlatform;
        this.log = log;
        this.forkNodeFactory = forkNodeFactory;
    }

    protected abstract void resolveClasspath(@Nonnull OutputStreamFlushableCommandline var1, @Nonnull String var2, @Nonnull StartupConfiguration var3, @Nonnull File var4) throws SurefireBooterForkException;

    @Nonnull
    protected String extendJvmArgLine(@Nonnull String jvmArgLine) {
        return jvmArgLine;
    }

    @Override
    @Nonnull
    public final ForkNodeFactory getForkNodeFactory() {
        return this.forkNodeFactory;
    }

    @Override
    @Nonnull
    public OutputStreamFlushableCommandline createCommandLine(@Nonnull StartupConfiguration config, int forkNumber, @Nonnull File dumpLogDirectory) throws SurefireBooterForkException {
        OutputStreamFlushableCommandline cli = new OutputStreamFlushableCommandline(this.getExcludedEnvironmentVariables());
        cli.setWorkingDirectory(this.getWorkingDirectory(forkNumber).getAbsolutePath());
        Iterator<Map.Entry<String, String>> iterator = this.getEnvironmentVariables().entrySet().iterator();
        while (iterator.hasNext()) {
            String value;
            Map.Entry<String, String> entry;
            cli.addEnvironment(entry.getKey(), (value = (entry = iterator.next()).getValue()) == null ? "" : value);
        }
        cli.setExecutable(this.getJdkForTests().getJvmExecutable().getAbsolutePath());
        String jvmArgLine = this.newJvmArgLine(forkNumber);
        if (!jvmArgLine.isEmpty()) {
            cli.createArg().setLine(jvmArgLine);
        }
        if (this.getDebugLine() != null && !this.getDebugLine().isEmpty()) {
            cli.createArg().setLine(this.getDebugLine());
        }
        this.resolveClasspath(cli, DefaultForkConfiguration.findStartClass(config), config, dumpLogDirectory);
        return cli;
    }

    protected ConsoleLogger getLogger() {
        return this.log;
    }

    @Nonnull
    protected List<String> toCompleteClasspath(@Nonnull StartupConfiguration conf) throws SurefireBooterForkException {
        AbstractPathConfiguration pathConfig = conf.getClasspathConfiguration();
        if (pathConfig.isClassPathConfig() == pathConfig.isModularPathConfig()) {
            throw new SurefireBooterForkException("Could not find class-path config nor modular class-path either.");
        }
        Classpath bootClasspath = this.getBooterClasspath();
        Classpath testClasspath = pathConfig.getTestClasspath();
        Classpath providerClasspath = pathConfig.getProviderClasspath();
        Classpath completeClasspath = Classpath.join((Classpath)Classpath.join((Classpath)bootClasspath, (Classpath)testClasspath), (Classpath)providerClasspath);
        this.getLogger().debug(completeClasspath.getLogMessage("boot classpath:"));
        this.getLogger().debug(completeClasspath.getCompactLogMessage("boot(compact) classpath:"));
        return completeClasspath.getClassPath();
    }

    @Nonnull
    private File getWorkingDirectory(int forkNumber) throws SurefireBooterForkException {
        File cwd = SurefireHelper.replaceForkThreadsInPath(this.getWorkingDirectory(), forkNumber);
        if (!cwd.exists() && !cwd.mkdirs()) {
            throw new SurefireBooterForkException("Cannot create workingDirectory " + cwd.getAbsolutePath());
        }
        if (!cwd.isDirectory()) {
            throw new SurefireBooterForkException("WorkingDirectory " + cwd.getAbsolutePath() + " exists and is not a directory");
        }
        return cwd;
    }

    @Nonnull
    private String interpolateArgLineWithPropertyExpressions() {
        if (this.getArgLine() == null) {
            return "";
        }
        String resolvedArgLine = this.getArgLine().trim();
        if (resolvedArgLine.isEmpty()) {
            return "";
        }
        for (String key : this.getModelProperties().stringPropertyNames()) {
            String field = "@{" + key + "}";
            if (!this.getArgLine().contains(field)) continue;
            resolvedArgLine = resolvedArgLine.replace(field, this.getModelProperties().getProperty(key, ""));
        }
        return resolvedArgLine;
    }

    @Nonnull
    private static String stripNewLines(@Nonnull String argLine) {
        return argLine.replace("\n", " ").replace("\r", " ");
    }

    @Nonnull
    private static <K, V> Map<K, V> toImmutable(@Nullable Map<K, V> map) {
        return map == null ? Collections.emptyMap() : new ImmutableMap(map);
    }

    @Override
    @Nonnull
    public File getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    @Nullable
    protected String getDebugLine() {
        return this.debugLine;
    }

    @Override
    @Nonnull
    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    @Nonnull
    protected Properties getModelProperties() {
        return this.modelProperties;
    }

    @Override
    @Nullable
    protected String getArgLine() {
        return this.argLine;
    }

    @Override
    @Nonnull
    protected Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nonnull
    protected String[] getExcludedEnvironmentVariables() {
        return this.excludedEnvironmentVariables;
    }

    @Override
    protected boolean isDebug() {
        return this.debug;
    }

    @Override
    protected int getForkCount() {
        return this.forkCount;
    }

    @Override
    protected boolean isReuseForks() {
        return this.reuseForks;
    }

    @Override
    @Nonnull
    protected Platform getPluginPlatform() {
        return this.pluginPlatform;
    }

    @Override
    @Nonnull
    protected JdkAttributes getJdkForTests() {
        return this.getPluginPlatform().getJdkExecAttributesForTests();
    }

    @Override
    @Nonnull
    protected Classpath getBooterClasspath() {
        return this.booterClasspath;
    }

    @Nonnull
    private String newJvmArgLine(int forks) {
        String interpolatedArgs = DefaultForkConfiguration.stripNewLines(this.interpolateArgLineWithPropertyExpressions());
        String argsWithReplacedForkNumbers = SurefireHelper.replaceThreadNumberPlaceholders(interpolatedArgs, forks);
        return this.extendJvmArgLine(argsWithReplacedForkNumbers);
    }

    @Nonnull
    private static String findStartClass(StartupConfiguration config) {
        return config.isShadefire() ? Relocator.relocate(DEFAULT_PROVIDER_CLASS) : DEFAULT_PROVIDER_CLASS;
    }
}

