/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.untag;

import java.io.File;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitUntagCommand
extends AbstractUntagCommand
implements GitCommand {
    private final Map<String, String> environmentVariables;

    public GitUntagCommand(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public ScmResult executeUntagCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        Commandline clPush;
        String tag = scmUntagParameters.getTag();
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag name must be specified");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline clTag = GitUntagCommand.createCommandLine(repository, fileSet.getBasedir(), tag);
        int exitCode = GitCommandLineUtils.execute(clTag, stdout, stderr);
        if (exitCode != 0) {
            return new UntagScmResult(clTag.toString(), "The git-tag command failed.", stderr.getOutput(), false);
        }
        if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = this.createPushCommandLine(repository, fileSet, tag), stdout, stderr)) != 0) {
            return new UntagScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
        }
        return new UntagScmResult(clTag.toString());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String tag) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "tag");
        cl.createArg().setValue("-d");
        cl.createArg().setValue(tag);
        return cl;
    }

    public Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String tag) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push", repository, this.environmentVariables);
        cl.createArg().setValue("--delete");
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/tags/" + tag);
        return cl;
    }
}

