/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.ReleaseDescriptor;

public class ReleaseUtils {
    private ReleaseUtils() {
    }

    public static ReleaseDescriptor merge(ReleaseDescriptor mergeInto, ReleaseDescriptor toBeMerged) {
        mergeInto.setScmSourceUrl(ReleaseUtils.mergeOverride(mergeInto.getScmSourceUrl(), toBeMerged.getScmSourceUrl()));
        mergeInto.setScmCommentPrefix(ReleaseUtils.mergeOverride(mergeInto.getScmCommentPrefix(), toBeMerged.getScmCommentPrefix()));
        mergeInto.setScmReleaseLabel(ReleaseUtils.mergeOverride(mergeInto.getScmReleaseLabel(), toBeMerged.getScmReleaseLabel()));
        mergeInto.setScmTagBase(ReleaseUtils.mergeOverride(mergeInto.getScmTagBase(), toBeMerged.getScmTagBase()));
        mergeInto.setScmBranchBase(ReleaseUtils.mergeOverride(mergeInto.getScmBranchBase(), toBeMerged.getScmBranchBase()));
        mergeInto.setScmUsername(ReleaseUtils.mergeOverride(mergeInto.getScmUsername(), toBeMerged.getScmUsername()));
        mergeInto.setScmPassword(ReleaseUtils.mergeOverride(mergeInto.getScmPassword(), toBeMerged.getScmPassword()));
        mergeInto.setScmPrivateKey(ReleaseUtils.mergeOverride(mergeInto.getScmPrivateKey(), toBeMerged.getScmPrivateKey()));
        mergeInto.setScmPrivateKeyPassPhrase(ReleaseUtils.mergeOverride(mergeInto.getScmPrivateKeyPassPhrase(), toBeMerged.getScmPrivateKeyPassPhrase()));
        mergeInto.setScmCommentPrefix(ReleaseUtils.mergeOverride(mergeInto.getScmCommentPrefix(), toBeMerged.getScmCommentPrefix()));
        mergeInto.setAdditionalArguments(ReleaseUtils.mergeOverride(mergeInto.getAdditionalArguments(), toBeMerged.getAdditionalArguments()));
        mergeInto.setPreparationGoals(ReleaseUtils.mergeOverride(mergeInto.getPreparationGoals(), toBeMerged.getPreparationGoals()));
        mergeInto.setPerformGoals(ReleaseUtils.mergeOverride(mergeInto.getPerformGoals(), toBeMerged.getPerformGoals()));
        mergeInto.setPomFileName(ReleaseUtils.mergeOverride(mergeInto.getPomFileName(), toBeMerged.getPomFileName()));
        mergeInto.setScmUseEditMode(toBeMerged.isScmUseEditMode());
        mergeInto.setAddSchema(toBeMerged.isAddSchema());
        mergeInto.setGenerateReleasePoms(toBeMerged.isGenerateReleasePoms());
        mergeInto.setInteractive(toBeMerged.isInteractive());
        mergeInto.setUpdateDependencies(toBeMerged.isUpdateDependencies());
        mergeInto.setCommitByProject(toBeMerged.isCommitByProject());
        mergeInto.setUseReleaseProfile(toBeMerged.isUseReleaseProfile());
        mergeInto.setBranchCreation(toBeMerged.isBranchCreation());
        mergeInto.setUpdateBranchVersions(toBeMerged.isUpdateBranchVersions());
        mergeInto.setUpdateWorkingCopyVersions(toBeMerged.isUpdateWorkingCopyVersions());
        mergeInto.setUpdateVersionsToSnapshot(toBeMerged.isUpdateVersionsToSnapshot());
        mergeInto.setAllowTimestampedSnapshots(toBeMerged.isAllowTimestampedSnapshots());
        mergeInto.setSnapshotReleasePluginAllowed(toBeMerged.isSnapshotReleasePluginAllowed());
        mergeInto.setAutoVersionSubmodules(toBeMerged.isAutoVersionSubmodules());
        mergeInto.setDefaultReleaseVersion(ReleaseUtils.mergeOverride(mergeInto.getDefaultReleaseVersion(), toBeMerged.getDefaultReleaseVersion()));
        mergeInto.setDefaultDevelopmentVersion(ReleaseUtils.mergeOverride(mergeInto.getDefaultDevelopmentVersion(), toBeMerged.getDefaultDevelopmentVersion()));
        mergeInto.setRemoteTagging(toBeMerged.isRemoteTagging());
        mergeInto.setLocalCheckout(toBeMerged.isLocalCheckout());
        if (toBeMerged.getReleaseVersions() != null) {
            mergeInto.getReleaseVersions().putAll(toBeMerged.getReleaseVersions());
        }
        if (toBeMerged.getDevelopmentVersions() != null) {
            mergeInto.getDevelopmentVersions().putAll(toBeMerged.getDevelopmentVersions());
        }
        mergeInto.setWorkingDirectory(ReleaseUtils.mergeOverride(mergeInto.getWorkingDirectory(), toBeMerged.getWorkingDirectory()));
        mergeInto.setCheckoutDirectory(ReleaseUtils.mergeOverride(mergeInto.getCheckoutDirectory(), toBeMerged.getCheckoutDirectory()));
        mergeInto.setCompletedPhase(ReleaseUtils.mergeDefault(mergeInto.getCompletedPhase(), toBeMerged.getCompletedPhase()));
        return mergeInto;
    }

    private static String mergeOverride(String thisValue, String mergeValue) {
        return mergeValue != null ? mergeValue : thisValue;
    }

    private static String mergeDefault(String thisValue, String mergeValue) {
        return thisValue != null ? thisValue : mergeValue;
    }

    public static ReleaseDescriptor copyPropertiesToReleaseDescriptor(Properties properties) {
        ReleaseDescriptor releaseDescriptor = new ReleaseDescriptor();
        releaseDescriptor.setCompletedPhase(properties.getProperty("completedPhase"));
        releaseDescriptor.setScmSourceUrl(properties.getProperty("scm.url"));
        releaseDescriptor.setScmUsername(properties.getProperty("scm.username"));
        releaseDescriptor.setScmPassword(properties.getProperty("scm.password"));
        releaseDescriptor.setScmPrivateKey(properties.getProperty("scm.privateKey"));
        releaseDescriptor.setScmPrivateKeyPassPhrase(properties.getProperty("scm.passphrase"));
        releaseDescriptor.setScmTagBase(properties.getProperty("scm.tagBase"));
        releaseDescriptor.setScmBranchBase(properties.getProperty("scm.branchBase"));
        releaseDescriptor.setScmReleaseLabel(properties.getProperty("scm.tag"));
        releaseDescriptor.setScmCommentPrefix(properties.getProperty("scm.commentPrefix"));
        releaseDescriptor.setAdditionalArguments(properties.getProperty("exec.additionalArguments"));
        releaseDescriptor.setPomFileName(properties.getProperty("exec.pomFileName"));
        releaseDescriptor.setPreparationGoals(properties.getProperty("preparationGoals"));
        String remoteTaggingStr = properties.getProperty("remoteTagging");
        releaseDescriptor.setRemoteTagging(remoteTaggingStr == null ? false : Boolean.valueOf(remoteTaggingStr));
        ReleaseUtils.loadResolvedDependencies(properties, releaseDescriptor);
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            int index;
            String property = (String)i.next();
            if (property.startsWith("project.rel.")) {
                releaseDescriptor.mapReleaseVersion(property.substring("project.rel.".length()), properties.getProperty(property));
                continue;
            }
            if (property.startsWith("project.dev.")) {
                releaseDescriptor.mapDevelopmentVersion(property.substring("project.dev.".length()), properties.getProperty(property));
                continue;
            }
            if (!property.startsWith("project.scm.") || (index = property.lastIndexOf(46)) <= "project.scm.".length()) continue;
            String key = property.substring("project.scm.".length(), index);
            if (releaseDescriptor.getOriginalScmInfo().containsKey(key)) continue;
            if (properties.getProperty("project.scm." + key + ".empty") != null) {
                releaseDescriptor.mapOriginalScmInfo(key, null);
                continue;
            }
            Scm scm = new Scm();
            scm.setConnection(properties.getProperty("project.scm." + key + ".connection"));
            scm.setDeveloperConnection(properties.getProperty("project.scm." + key + ".developerConnection"));
            scm.setUrl(properties.getProperty("project.scm." + key + ".url"));
            scm.setTag(properties.getProperty("project.scm." + key + ".tag"));
            releaseDescriptor.mapOriginalScmInfo(key, scm);
        }
        return releaseDescriptor;
    }

    private static void loadResolvedDependencies(Properties prop, ReleaseDescriptor descriptor) {
        HashMap resolvedDependencies = new HashMap();
        Set<Map.Entry<Object, Object>> entries = prop.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            String versionType;
            int endIndex;
            Map.Entry<Object, Object> currentEntry = iterator.next();
            String propertyName = (String)currentEntry.getKey();
            if (!propertyName.startsWith("dependency.")) continue;
            Map<String, Object> versionMap = new HashMap();
            int startIndex = propertyName.lastIndexOf("dependency.");
            if (propertyName.indexOf(".development") != -1) {
                endIndex = propertyName.indexOf(".development");
                versionType = "dev";
            } else {
                endIndex = propertyName.indexOf(".release");
                versionType = "rel";
            }
            String artifactVersionlessKey = propertyName.substring(startIndex, endIndex);
            if (resolvedDependencies.containsKey(artifactVersionlessKey)) {
                versionMap = (Map)resolvedDependencies.get(artifactVersionlessKey);
            } else {
                versionMap = new HashMap();
                resolvedDependencies.put(artifactVersionlessKey, versionMap);
            }
            versionMap.put(versionType, currentEntry.getValue());
        }
        descriptor.setResolvedSnapshotDependencies(resolvedDependencies);
    }
}

