/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.MavenReportExecution;
import org.apache.maven.plugins.site.MavenReportExecutor;
import org.apache.maven.plugins.site.MavenReportExecutorRequest;
import org.apache.maven.plugins.site.ReportDocumentRenderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.PlexusContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteRenderingMojo
extends AbstractSiteMojo {
    protected Map moduleExcludes;
    protected DecorationModelInheritanceAssembler assembler;
    protected ArtifactResolver artifactResolver;
    protected List<ArtifactRepository> repositories;
    protected ArtifactFactory artifactFactory;
    private File templateDirectory;
    private String template;
    private File templateFile;
    protected Map<Object, Object> attributes;
    protected Renderer siteRenderer;
    private File xdocDirectory;
    protected File generatedSiteDirectory;
    protected MavenProject project;
    protected MavenSession mavenSession;
    protected PlexusContainer plexusContainer;
    protected MavenReportExecutor mavenReportExecutor;

    protected List<MavenReportExecution> getReports() throws MojoExecutionException {
        if (this.reportPlugins == null || this.reportPlugins.length <= 0) {
            return Collections.emptyList();
        }
        MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
        mavenReportExecutorRequest.setLocalRepository(this.localRepository);
        mavenReportExecutorRequest.setMavenSession(this.mavenSession);
        mavenReportExecutorRequest.setProject(this.project);
        mavenReportExecutorRequest.setReportPlugins(this.reportPlugins);
        return this.mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
    }

    protected List<MavenReportExecution> filterReports(List<MavenReportExecution> reports) {
        ArrayList<MavenReportExecution> filteredReports = new ArrayList<MavenReportExecution>();
        for (MavenReportExecution mavenReportExecution : reports) {
            MavenReport report = mavenReportExecution.getMavenReport();
            try {
                if (!report.canGenerateReport()) continue;
                filteredReports.add(mavenReportExecution);
            }
            catch (AbstractMethodError e) {
                this.getLog().warn((CharSequence)("Error loading report " + report.getClass().getName() + " - AbstractMethodError: canGenerateReport()"));
                filteredReports.add(mavenReportExecution);
            }
        }
        return filteredReports;
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        File skinFile;
        DecorationModel decorationModel;
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("inputEncoding") == null) {
            this.attributes.put("inputEncoding", this.getInputEncoding());
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.getOutputEncoding());
        }
        this.attributes.putAll(this.project.getProperties());
        try {
            decorationModel = this.siteTool.getDecorationModel(this.project, this.reactorProjects, this.localRepository, this.repositories, AbstractSiteRenderingMojo.toRelative(this.project.getBasedir(), this.siteDirectory.getAbsolutePath()), locale, this.getInputEncoding(), this.getOutputEncoding());
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.template != null) {
            if (this.templateFile != null) {
                this.getLog().warn((CharSequence)"'template' configuration is ignored when 'templateFile' is set");
            } else {
                this.templateFile = new File(this.templateDirectory, this.template);
            }
        }
        try {
            Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.repositories, decorationModel);
            this.getLog().info((CharSequence)("Rendering site with " + skinArtifact.getId() + " skin."));
            skinFile = skinArtifact.getFile();
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.templateFile != null) {
            if (!this.templateFile.exists()) {
                throw new MojoFailureException("Template file '" + this.templateFile + "' does not exist");
            }
            context = this.siteRenderer.createContextForTemplate(this.templateFile, skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        } else {
            context = this.siteRenderer.createContextForSkin(skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        }
        if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "xdoc");
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "fml");
        } else {
            context.addSiteDirectory(this.siteDirectory);
            context.addModuleDirectory(this.xdocDirectory, "xdoc");
            context.addModuleDirectory(this.xdocDirectory, "fml");
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        return context;
    }

    protected Map<String, MavenReport> locateReports(List<MavenReportExecution> reports, Map<String, DocumentRenderer> documents, Locale locale) {
        ArrayList<MavenReportExecution> filtered = new ArrayList<MavenReportExecution>(reports);
        HashMap<String, MavenReport> reportsByOutputName = new HashMap<String, MavenReport>();
        for (MavenReportExecution mavenReportExecution : filtered) {
            MavenReport report = mavenReportExecution.getMavenReport();
            String outputName = report.getOutputName() + ".html";
            reportsByOutputName.put(report.getOutputName(), report);
            if (documents.containsKey(outputName)) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + outputName + "\" already exists for the " + displayLanguage + " version."));
                reports.remove(mavenReportExecution);
                continue;
            }
            RenderingContext renderingContext = new RenderingContext(this.siteDirectory, outputName);
            ReportDocumentRenderer renderer = new ReportDocumentRenderer(mavenReportExecution, renderingContext, this.getLog());
            documents.put(outputName, renderer);
        }
        return reportsByOutputName;
    }

    protected Map<String, List<MavenReport>> categoriseReports(Collection<MavenReport> reports) {
        HashMap<String, List<MavenReport>> categories = new HashMap<String, List<MavenReport>>();
        for (MavenReport report : reports) {
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map<String, DocumentRenderer> locateDocuments(SiteRenderingContext context, List<MavenReportExecution> reports, Locale locale) throws IOException, RendererException {
        CategorySummaryDocumentRenderer renderer;
        String desc2;
        String desc1;
        String title;
        RenderingContext renderingContext;
        List<MavenReport> categoryReports;
        Map documents = this.siteRenderer.locateDocumentFiles(context);
        Map<String, MavenReport> reportsByOutputName = this.locateReports(reports, documents, locale);
        Map<String, List<MavenReport>> categories = this.categoriseReports(reportsByOutputName.values());
        this.siteTool.populateReportsMenu(context.getDecoration(), locale, categories);
        this.populateReportItems(context.getDecoration(), locale, reportsByOutputName);
        if (categories.containsKey("Project Info")) {
            categoryReports = categories.get("Project Info");
            renderingContext = new RenderingContext(this.siteDirectory, "project-info.html");
            title = this.i18n.getString("site-plugin", locale, "report.information.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = categories.get("Project Reports");
            renderingContext = new RenderingContext(this.siteDirectory, "project-reports.html");
            title = this.i18n.getString("site-plugin", locale, "report.project.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        return documents;
    }
}

