/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

@Named
@Singleton
public class ConfigurationService {
    private final Provider<MavenSession> sessionProvider;
    private final RepositorySystem repositorySystem;

    @Inject
    public ConfigurationService(Provider<MavenSession> sessionProvider, RepositorySystem repositorySystem) {
        this.sessionProvider = sessionProvider;
        this.repositorySystem = repositorySystem;
    }

    public List<File> resolveDependenciesAsFile(MavenProject localProject, Collection<MavenProject> aggregatedProjects, boolean includeTests) throws DependencyResolutionException {
        RepositorySystemSession repositorySession = ((MavenSession)this.sessionProvider.get()).getRepositorySession();
        ArtifactTypeRegistry artifactTypeRegistry = repositorySession.getArtifactTypeRegistry();
        List<String> includesScope = includeTests ? Arrays.asList("compile", "provided", "test") : Arrays.asList("compile", "provided");
        ArrayList<String> exclusionPatterns = new ArrayList<String>();
        for (MavenProject project : aggregatedProjects) {
            exclusionPatterns.add(this.getExclusionKey(project));
        }
        List dependencies = localProject.getDependencies().stream().filter(dependency -> includesScope.contains(dependency.getScope())).filter(dependency -> !exclusionPatterns.contains(this.getExclusionKey((Dependency)dependency))).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        List dependencyManagements = Optional.ofNullable(localProject.getDependencyManagement()).map(DependencyManagement::getDependencies).map(Collection::stream).orElse(Stream.empty()).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        CollectRequest collectRequest = new CollectRequest(dependencies, dependencyManagements, localProject.getRemoteProjectRepositories());
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        DependencyResult result = this.repositorySystem.resolveDependencies(((MavenSession)this.sessionProvider.get()).getRepositorySession(), request);
        return result.getArtifactResults().stream().map(ArtifactResult::getArtifact).map(Artifact::getFile).collect(Collectors.toList());
    }

    private String getExclusionKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId();
    }

    private String getExclusionKey(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId();
    }
}

