/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import org.apache.maven.plugins.ear.JbossConfiguration;
import org.apache.maven.plugins.ear.util.ArtifactRepository;
import org.apache.maven.plugins.ear.util.ArtifactTypeMappingService;
import org.apache.maven.project.MavenProject;

public class EarExecutionContext {
    private String defaultLibBundleDir;
    private JbossConfiguration jbossConfiguration;
    private String outputFileNameMapping;
    private ArtifactRepository artifactRepository;

    public EarExecutionContext(MavenProject project, String mainArtifactId, String defaultLibBundleDir, JbossConfiguration jbossConfiguration, String fileNameMappingName, ArtifactTypeMappingService typeMappingService) {
        this.initialize(project, mainArtifactId, defaultLibBundleDir, jbossConfiguration, fileNameMappingName, typeMappingService);
    }

    public String getDefaultLibBundleDir() {
        return this.defaultLibBundleDir;
    }

    public boolean isJbossConfigured() {
        return this.jbossConfiguration != null;
    }

    public String getOutputFileNameMapping() {
        return this.outputFileNameMapping;
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    private void initialize(MavenProject project, String mainArtifactId, String defaultLibBundleDir, JbossConfiguration jbossConfiguration, String outputFileNameMapping, ArtifactTypeMappingService typeMappingService) {
        this.artifactRepository = new ArtifactRepository(project.getArtifacts(), mainArtifactId, typeMappingService);
        this.defaultLibBundleDir = defaultLibBundleDir;
        this.jbossConfiguration = jbossConfiguration;
        this.outputFileNameMapping = outputFileNameMapping;
    }
}

