/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_LEGACY_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+?)::(.+)");
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+)");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="deployAtEnd")
    private boolean deployAtEnd;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(property="maven.deploy.skip", defaultValue="false")
    private String skip = Boolean.FALSE.toString();
    @Parameter(defaultValue="false", property="allowIncompleteProjects")
    private boolean allowIncompleteProjects;
    private static final String DEPLOY_PROCESSED_MARKER = DeployMojo.class.getName() + ".processed";
    private static final String DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altReleaseDeploymentRepository";
    private static final String DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altSnapshotDeploymentRepository";
    private static final String DEPLOY_ALT_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altDeploymentRepository";

    private void putState(State state) {
        this.getPluginContext().put(DEPLOY_PROCESSED_MARKER, state.name());
    }

    private void putPluginContextValue(String key, String value) {
        if (value != null) {
            this.getPluginContext().put(key, value);
        }
    }

    private String getPluginContextValue(Map<String, Object> pluginContext, String key) {
        return (String)pluginContext.get(key);
    }

    private State getState(Map<String, Object> pluginContext) {
        return State.valueOf(this.getPluginContextValue(pluginContext, DEPLOY_PROCESSED_MARKER));
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(DEPLOY_PROCESSED_MARKER);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        State state;
        if (Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !ArtifactUtils.isSnapshot((String)this.project.getVersion()) || "snapshots".equals(this.skip) && ArtifactUtils.isSnapshot((String)this.project.getVersion())) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            state = State.SKIPPED;
        } else {
            this.failIfOffline();
            this.warnIfAffectedPackagingAndMaven(this.project.getPackaging());
            if (!this.deployAtEnd) {
                RemoteRepository deploymentRepository = this.getDeploymentRepository(this.project, this.altSnapshotDeploymentRepository, this.altReleaseDeploymentRepository, this.altDeploymentRepository);
                DeployRequest request = new DeployRequest();
                request.setRepository(deploymentRepository);
                this.processProject(this.project, request);
                this.deploy(request);
                state = State.DEPLOYED;
            } else {
                this.putPluginContextValue(DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY, this.altSnapshotDeploymentRepository);
                this.putPluginContextValue(DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY, this.altReleaseDeploymentRepository);
                this.putPluginContextValue(DEPLOY_ALT_DEPLOYMENT_REPOSITORY, this.altDeploymentRepository);
                state = State.TO_BE_DEPLOYED;
            }
        }
        this.putState(state);
        List<MavenProject> allProjectsUsingPlugin = this.getAllProjectsUsingPlugin();
        if (this.allProjectsMarked(allProjectsUsingPlugin)) {
            this.deployAllAtOnce(allProjectsUsingPlugin);
        } else if (state == State.TO_BE_DEPLOYED) {
            this.getLog().info((CharSequence)("Deferring deploy for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
        }
    }

    private void deployAllAtOnce(List<MavenProject> allProjectsUsingPlugin) throws MojoExecutionException {
        LinkedHashMap<RemoteRepository, DeployRequest> requests = new LinkedHashMap<RemoteRepository, DeployRequest>();
        for (MavenProject reactorProject : allProjectsUsingPlugin) {
            Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, reactorProject);
            State state = this.getState(pluginContext);
            if (state != State.TO_BE_DEPLOYED) continue;
            RemoteRepository deploymentRepository = this.getDeploymentRepository(reactorProject, this.getPluginContextValue(pluginContext, DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY), this.getPluginContextValue(pluginContext, DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY), this.getPluginContextValue(pluginContext, DEPLOY_ALT_DEPLOYMENT_REPOSITORY));
            DeployRequest request = requests.computeIfAbsent(deploymentRepository, repo -> {
                DeployRequest newRequest = new DeployRequest();
                newRequest.setRepository(repo);
                return newRequest;
            });
            this.processProject(reactorProject, request);
        }
        for (DeployRequest request : requests.values()) {
            this.deploy(request);
        }
    }

    private boolean allProjectsMarked(List<MavenProject> allProjectsUsingPlugin) {
        for (MavenProject reactorProject : allProjectsUsingPlugin) {
            if (this.hasState(reactorProject)) continue;
            return false;
        }
        return true;
    }

    private List<MavenProject> getAllProjectsUsingPlugin() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject reactorProject : this.reactorProjects) {
            if (!this.hasExecution(reactorProject.getPlugin("org.apache.maven.plugins:maven-deploy-plugin"))) continue;
            result.add(reactorProject);
        }
        return result;
    }

    private boolean hasExecution(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        for (PluginExecution execution : plugin.getExecutions()) {
            if (execution.getGoals().isEmpty() || "none".equalsIgnoreCase(execution.getPhase())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processProject(MavenProject project, DeployRequest request) throws MojoExecutionException {
        boolean isIncomplete;
        Artifact projectArtifact;
        Artifact pomArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)new ProjectArtifact(project));
        if (ArtifactIdUtils.equalsId((Artifact)pomArtifact, (Artifact)(projectArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact())))) {
            if (this.isFile(projectArtifact.getFile())) {
                pomArtifact = projectArtifact;
            }
            projectArtifact = null;
        }
        if (!this.isFile(pomArtifact.getFile())) {
            throw new MojoExecutionException("The POM for project " + project.getArtifactId() + " could not be attached");
        }
        request.addArtifact(pomArtifact);
        boolean bl = isIncomplete = projectArtifact != null && !this.isFile(projectArtifact.getFile());
        if (projectArtifact != null) {
            if (!isIncomplete) {
                request.addArtifact(projectArtifact);
            } else {
                if (project.getAttachedArtifacts().isEmpty()) throw new MojoExecutionException("The packaging plugin for project " + project.getArtifactId() + " did not assign a file to the build artifact");
                if (!this.allowIncompleteProjects) throw new MojoExecutionException("The packaging plugin for project " + project.getArtifactId() + " did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                this.getLog().warn((CharSequence)"");
                this.getLog().warn((CharSequence)("The packaging plugin for project " + project.getArtifactId() + " did not assign"));
                this.getLog().warn((CharSequence)"a main file to the project but it has attachments. Change packaging to 'pom'.");
                this.getLog().warn((CharSequence)"");
                this.getLog().warn((CharSequence)"Incomplete projects like this will fail in future Maven versions!");
                this.getLog().warn((CharSequence)"");
            }
        }
        for (org.apache.maven.artifact.Artifact attached : project.getAttachedArtifacts()) {
            this.getLog().debug((CharSequence)("Attaching for deploy: " + attached.getId()));
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)attached));
        }
    }

    private boolean isFile(File file) {
        return file != null && file.isFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RemoteRepository getDeploymentRepository(MavenProject project, String altSnapshotDeploymentRepository, String altReleaseDeploymentRepository, String altDeploymentRepository) throws MojoExecutionException {
        RemoteRepository repo = null;
        String altDeploymentRepo = ArtifactUtils.isSnapshot((String)project.getVersion()) && altSnapshotDeploymentRepository != null ? altSnapshotDeploymentRepository : (!ArtifactUtils.isSnapshot((String)project.getVersion()) && altReleaseDeploymentRepository != null ? altReleaseDeploymentRepository : altDeploymentRepository);
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_LEGACY_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (matcher.matches()) {
                String id = matcher.group(1).trim();
                String layout = matcher.group(2).trim();
                String url = matcher.group(3).trim();
                if (!"default".equals(layout)) throw new MojoExecutionException("Invalid legacy syntax and layout for alternative repository: \"" + altDeploymentRepo + "\". Use \"" + id + "::" + url + "\" instead, and only default layout is supported.");
                this.getLog().warn((CharSequence)("Using legacy syntax for alternative repository. Use \"" + id + "::" + url + "\" instead."));
                repo = this.getRemoteRepository(id, url);
            } else {
                matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
                if (!matcher.matches()) {
                    throw new MojoExecutionException("Invalid syntax for alternative repository: \"" + altDeploymentRepo + "\". Use \"id::url\".");
                }
                String id = matcher.group(1).trim();
                String url = matcher.group(2).trim();
                repo = this.getRemoteRepository(id, url);
            }
        }
        if (repo == null) {
            repo = RepositoryUtils.toRepo((ArtifactRepository)project.getDistributionManagementArtifactRepository());
        }
        if (repo != null) return repo;
        String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::url parameter";
        throw new MojoExecutionException(msg);
    }

    private static enum State {
        SKIPPED,
        DEPLOYED,
        TO_BE_DEPLOYED;

    }
}

