/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraXML
extends DefaultHandler {
    private final List<Issue> issueList;
    private final StringBuilder currentElement = new StringBuilder(1024);
    private String currentParent = "";
    private final String datePattern;
    private Issue issue;
    private String jiraVersion = null;
    private final Log log;
    private SimpleDateFormat sdf = null;

    public JiraXML(Log log, String datePattern) {
        this.log = log;
        this.datePattern = datePattern;
        this.sdf = datePattern == null ? null : new SimpleDateFormat(datePattern, Locale.ENGLISH);
        this.issueList = new ArrayList<Issue>(16);
    }

    public void parseXML(File xmlPath) throws MojoExecutionException {
        FileInputStream xmlStream = null;
        try {
            xmlStream = new FileInputStream(xmlPath);
            InputSource inputSource = new InputSource(xmlStream);
            this.parse(inputSource);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Failed to open JIRA XML file " + xmlPath, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(xmlStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)xmlStream);
    }

    void parse(InputSource xmlSource) throws MojoExecutionException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xmlSource, (DefaultHandler)this);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Failed to parse JIRA XML.", t);
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("item")) {
            this.issue = new Issue();
            this.currentParent = "item";
        } else if (qName.equals("key")) {
            String id = attrs.getValue("id");
            if (id != null) {
                this.issue.setId(id.trim());
            }
        } else if (qName.equals("build-info")) {
            this.currentParent = "build-info";
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("item")) {
            this.issueList.add(this.issue);
            this.currentParent = "";
        } else if (qName.equals("key")) {
            this.issue.setKey(this.currentElement.toString().trim());
        } else if (qName.equals("summary")) {
            this.issue.setSummary(this.currentElement.toString().trim());
        } else if (qName.equals("type")) {
            this.issue.setType(this.currentElement.toString().trim());
        } else if (qName.equals("link") && this.currentParent.equals("item")) {
            this.issue.setLink(this.currentElement.toString().trim());
        } else if (qName.equals("priority")) {
            this.issue.setPriority(this.currentElement.toString().trim());
        } else if (qName.equals("status")) {
            this.issue.setStatus(this.currentElement.toString().trim());
        } else if (qName.equals("resolution")) {
            this.issue.setResolution(this.currentElement.toString().trim());
        } else if (qName.equals("assignee")) {
            this.issue.setAssignee(this.currentElement.toString().trim());
        } else if (qName.equals("reporter")) {
            this.issue.setReporter(this.currentElement.toString().trim());
        } else if (qName.equals("version") && this.currentParent.equals("item")) {
            this.issue.setVersion(this.currentElement.toString().trim());
        } else if (qName.equals("version") && this.currentParent.equals("build-info")) {
            this.jiraVersion = this.currentElement.toString().trim();
        } else if (qName.equals("fixVersion")) {
            this.issue.addFixVersion(this.currentElement.toString().trim());
        } else if (qName.equals("component")) {
            this.issue.addComponent(this.currentElement.toString().trim());
        } else if (qName.equals("comment")) {
            this.issue.addComment(this.currentElement.toString().trim());
        } else if (qName.equals("title") && this.currentParent.equals("item")) {
            this.issue.setTitle(this.currentElement.toString().trim());
        } else if (qName.equals("created") && this.currentParent.equals("item") && this.sdf != null) {
            try {
                this.issue.setCreated(this.sdf.parse(this.currentElement.toString().trim()));
            }
            catch (ParseException e) {
                this.log.warn((CharSequence)("Element \"Created\". " + e.getMessage() + ". Using the pattern \"" + this.datePattern + "\""));
            }
        } else if (qName.equals("updated") && this.currentParent.equals("item") && this.sdf != null) {
            try {
                this.issue.setUpdated(this.sdf.parse(this.currentElement.toString().trim()));
            }
            catch (ParseException e) {
                this.log.warn((CharSequence)("Element \"Updated\". " + e.getMessage() + ". Using the pattern \"" + this.datePattern + "\""));
            }
        }
        this.currentElement.setLength(0);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentElement.append(buf, offset, len);
    }

    public List<Issue> getIssueList() {
        return Collections.unmodifiableList(this.issueList);
    }

    public String getJiraVersion() {
        return this.jiraVersion;
    }
}

