/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.mojos;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.archive.ArchiveExpansionException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

@Deprecated
@Mojo(name="unpack", requiresDependencyResolution=ResolutionScope.TEST, inheritByDefault=false)
public class UnpackMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(defaultValue="${project.build.directory}/assembly/work", required=true)
    protected File workDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set projectArtifacts;
        LinkedHashSet<Artifact> dependencies = new LinkedHashSet<Artifact>();
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            dependencies.add(this.project.getArtifact());
        }
        if ((projectArtifacts = this.project.getArtifacts()) != null) {
            dependencies.addAll(projectArtifacts);
        }
        for (Artifact artifact : dependencies) {
            String name = artifact.getFile().getName();
            File tempLocation = new File(this.workDirectory, name.substring(0, name.lastIndexOf(46)));
            boolean process = false;
            if (!tempLocation.exists()) {
                tempLocation.mkdirs();
                process = true;
            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                process = true;
            }
            if (!process) continue;
            File file = artifact.getFile();
            try {
                AssemblyFileUtils.unpack(file, tempLocation, this.archiverManager);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
            catch (ArchiveExpansionException e) {
                throw new MojoExecutionException("Error unpacking dependency file: " + file, (Exception)e);
            }
        }
    }
}

