/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugin.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDependencySetsTask
implements ArchiverTask {
    private static final List<String> NON_ARCHIVE_DEPENDENCY_TYPES;
    private final List<DependencySet> dependencySets;
    private final Logger logger;
    private final MavenProject project;
    private MavenProject moduleProject;
    private final MavenProjectBuilder projectBuilder;
    private String defaultOutputDirectory;
    private String defaultOutputFileNameMapping;
    private Artifact moduleArtifact;
    private final Set<Artifact> resolvedArtifacts;
    private final ArchiverManager archiverManager;

    public AddDependencySetsTask(List<DependencySet> dependencySets, Set<Artifact> resolvedArtifacts, MavenProject project, MavenProjectBuilder projectBuilder, ArchiverManager archiverManager, Logger logger) {
        this.dependencySets = dependencySets;
        this.resolvedArtifacts = resolvedArtifacts;
        this.project = project;
        this.projectBuilder = projectBuilder;
        this.archiverManager = archiverManager;
        this.logger = logger;
    }

    @Override
    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (this.dependencySets == null || this.dependencySets.isEmpty()) {
            this.logger.debug("No dependency sets specified.");
            return;
        }
        List deps = this.project.getDependencies();
        if (deps == null || deps.isEmpty()) {
            this.logger.debug("Project " + this.project.getId() + " has no dependencies. Skipping dependency set addition.");
        }
        for (DependencySet dependencySet : this.dependencySets) {
            this.addDependencySet(dependencySet, archiver, configSource);
        }
    }

    protected void addDependencySet(DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException, InvalidAssemblerConfigurationException {
        this.logger.debug("Processing DependencySet (output=" + dependencySet.getOutputDirectory() + ")");
        if (!dependencySet.isUseTransitiveDependencies() && dependencySet.isUseTransitiveFiltering()) {
            this.logger.warn("DependencySet has nonsensical configuration: useTransitiveDependencies == false AND useTransitiveFiltering == true. Transitive filtering flag will be ignored.");
        }
        Set<Artifact> dependencyArtifacts = this.resolveDependencyArtifacts(dependencySet);
        boolean filterContents = false;
        UnpackOptions opts = dependencySet.getUnpackOptions();
        if (dependencySet.isUnpack() && opts != null && (opts.isFiltered() || opts.getLineEnding() != null)) {
            filterContents = true;
        } else if (dependencyArtifacts.size() > 1) {
            this.checkMultiArtifactOutputConfig(dependencySet);
        }
        this.logger.debug("Adding " + dependencyArtifacts.size() + " dependency artifacts.");
        for (Artifact depArtifact : dependencyArtifacts) {
            MavenProject depProject;
            try {
                depProject = this.projectBuilder.buildFromRepository(depArtifact, configSource.getRemoteRepositories(), configSource.getLocalRepository());
            }
            catch (ProjectBuildingException e) {
                this.logger.debug("Error retrieving POM of module-dependency: " + depArtifact.getId() + "; Reason: " + e.getMessage() + "\n\nBuilding stub project instance.");
                depProject = this.buildProjectStub(depArtifact);
            }
            if (NON_ARCHIVE_DEPENDENCY_TYPES.contains(depArtifact.getType())) {
                this.addNonArchiveDependency(depArtifact, depProject, dependencySet, archiver, configSource);
                continue;
            }
            if (filterContents) {
                this.addFilteredUnpackedArtifact(dependencySet, depArtifact, depProject, archiver, configSource);
                continue;
            }
            this.addNormalArtifact(dependencySet, depArtifact, depProject, archiver, configSource);
        }
    }

    private void checkMultiArtifactOutputConfig(DependencySet dependencySet) {
        String mapping;
        String dir = dependencySet.getOutputDirectory();
        if (dir == null) {
            dir = this.defaultOutputDirectory;
        }
        if ((mapping = dependencySet.getOutputFileNameMapping()) == null) {
            mapping = this.defaultOutputFileNameMapping;
        }
        if (!(dir != null && dir.indexOf("${") >= 0 || mapping != null && mapping.indexOf("${") >= 0)) {
            this.logger.warn("NOTE: Your assembly specifies a dependencySet that matches multiple artifacts, but specifies a concrete output format. THIS MAY RESULT IN ONE OR MORE ARTIFACTS BEING OBSCURED!\n\nOutput directory: '" + dir + "'\nOutput filename mapping: '" + mapping + "'");
        }
    }

    private void addFilteredUnpackedArtifact(DependencySet dependencySet, Artifact depArtifact, MavenProject depProject, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        String filenameMapping;
        this.logger.debug("Adding dependency artifact" + depArtifact.getId() + " after filtering the unpacked contents.");
        StringBuilder sb = new StringBuilder().append(depArtifact.getGroupId()).append("_").append(depArtifact.getArtifactId()).append("_").append(depArtifact.getVersion());
        String classifier = depArtifact.getClassifier();
        if (classifier != null) {
            sb.append("_").append(classifier);
        }
        sb.append(".").append(depArtifact.getType());
        File dir = new File(configSource.getWorkingDirectory(), sb.toString());
        if (dir.exists()) {
            this.logger.debug("NOT unpacking: " + depArtifact.getId() + ". Directory already exists in workdir:\n\t" + dir.getAbsolutePath());
        } else {
            UnArchiver unarchiver;
            dir.mkdirs();
            try {
                unarchiver = this.archiverManager.getUnArchiver(depArtifact.getFile());
            }
            catch (NoSuchArchiverException e) {
                throw new ArchiveCreationException("Failed to retrieve un-archiver for: " + depArtifact.getId() + ". Dependency filtering cannot proceed.", e);
            }
            unarchiver.setDestDirectory(dir);
            unarchiver.setOverwrite(true);
            unarchiver.setSourceFile(depArtifact.getFile());
            unarchiver.setIgnorePermissions(configSource.isIgnorePermissions());
            try {
                unarchiver.extract();
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Failed to unpack dependency archive: " + depArtifact.getId() + ". Dependency filtering cannot proceed.", e);
            }
        }
        UnpackOptions opts = dependencySet.getUnpackOptions();
        FileSet fs = new FileSet();
        fs.setDirectory(dir.getAbsolutePath());
        fs.setDirectoryMode(dependencySet.getDirectoryMode());
        fs.setExcludes(opts.getExcludes());
        fs.setFileMode(dependencySet.getFileMode());
        fs.setFiltered(opts.isFiltered());
        fs.setIncludes(opts.getIncludes());
        String outDir = dependencySet.getOutputDirectory();
        if (outDir == null) {
            outDir = this.defaultOutputDirectory;
        }
        if ((filenameMapping = dependencySet.getOutputFileNameMapping()) == null) {
            filenameMapping = this.defaultOutputFileNameMapping;
        }
        filenameMapping = AssemblyFormatUtils.evaluateFileNameMapping(filenameMapping, depArtifact, configSource.getProject(), this.moduleProject, this.moduleArtifact, depProject, configSource);
        String outputLocation = new File(outDir, filenameMapping).getPath();
        fs.setOutputDirectory(outputLocation);
        fs.setLineEnding(opts.getLineEnding());
        fs.setUseDefaultExcludes(opts.isUseDefaultExcludes());
        AddFileSetsTask task = new AddFileSetsTask(fs);
        task.setProject(depProject);
        task.setModuleProject(this.moduleProject);
        task.setLogger(this.logger);
        task.execute(archiver, configSource);
    }

    private void addNormalArtifact(DependencySet dependencySet, Artifact depArtifact, MavenProject depProject, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException {
        int fileMode;
        this.logger.debug("Adding dependency artifact" + depArtifact.getId() + ".");
        AddArtifactTask task = new AddArtifactTask(depArtifact, this.logger);
        task.setProject(depProject);
        task.setModuleProject(this.moduleProject);
        task.setModuleArtifact(this.moduleArtifact);
        task.setOutputDirectory(dependencySet.getOutputDirectory(), this.defaultOutputDirectory);
        task.setFileNameMapping(dependencySet.getOutputFileNameMapping(), this.defaultOutputFileNameMapping);
        int dirMode = TypeConversionUtils.modeToInt(dependencySet.getDirectoryMode(), this.logger);
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger)) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(dependencySet.isUnpack());
        UnpackOptions opts = dependencySet.getUnpackOptions();
        if (dependencySet.isUnpack() && opts != null) {
            task.setIncludes(opts.getIncludes());
            task.setExcludes(opts.getExcludes());
        }
        task.execute(archiver, configSource);
    }

    private MavenProject buildProjectStub(Artifact depArtifact) {
        Model model = new Model();
        model.setGroupId(depArtifact.getGroupId());
        model.setArtifactId(depArtifact.getArtifactId());
        model.setVersion(depArtifact.getBaseVersion());
        model.setPackaging(depArtifact.getType());
        model.setDescription("Stub for " + depArtifact.getId());
        MavenProject project = new MavenProject(model);
        project.setArtifact(depArtifact);
        return project;
    }

    protected Set<Artifact> resolveDependencyArtifacts(DependencySet dependencySet) throws InvalidAssemblerConfigurationException {
        List attachments;
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        if (this.resolvedArtifacts != null) {
            dependencyArtifacts.addAll(this.resolvedArtifacts);
        }
        if (dependencySet.isUseProjectArtifact()) {
            Artifact projectArtifact = this.project.getArtifact();
            if (projectArtifact != null && projectArtifact.getFile() != null) {
                dependencyArtifacts.add(projectArtifact);
            } else {
                this.logger.warn("Cannot include project artifact: " + projectArtifact + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseProjectAttachments() && (attachments = this.project.getAttachedArtifacts()) != null) {
            for (Artifact attachment : attachments) {
                if (attachment.getFile() != null) {
                    dependencyArtifacts.add(attachment);
                    continue;
                }
                this.logger.warn("Cannot include attached artifact: " + this.project.getId() + " for project: " + this.project.getId() + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseTransitiveFiltering()) {
            this.logger.debug("Filtering dependency artifacts USING transitive dependency path information.");
        } else {
            this.logger.debug("Filtering dependency artifacts WITHOUT transitive dependency path information.");
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter(dependencySet.getScope());
        FilterUtils.filterArtifacts(dependencyArtifacts, dependencySet.getIncludes(), dependencySet.getExcludes(), dependencySet.isUseStrictFiltering(), dependencySet.isUseTransitiveFiltering(), this.logger, new ArtifactFilter[]{filter});
        return dependencyArtifacts;
    }

    protected void addNonArchiveDependency(Artifact depArtifact, MavenProject depProject, DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException {
        File source = depArtifact.getFile();
        String outputDirectory = dependencySet.getOutputDirectory();
        outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory, configSource.getProject(), this.moduleProject, depProject, depProject.getBuild().getFinalName(), configSource);
        String destName = AssemblyFormatUtils.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), depArtifact, configSource.getProject(), this.moduleProject, this.moduleArtifact, depProject, configSource);
        String target = outputDirectory.endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : outputDirectory + "/" + destName;
        try {
            int mode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger);
            if (mode > -1) {
                archiver.addFile(source, target, mode);
            } else {
                archiver.addFile(source, target);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
        }
    }

    public List<DependencySet> getDependencySets() {
        return this.dependencySets;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    public void setDefaultOutputDirectory(String defaultOutputDirectory) {
        this.defaultOutputDirectory = defaultOutputDirectory;
    }

    public String getDefaultOutputFileNameMapping() {
        return this.defaultOutputFileNameMapping;
    }

    public void setDefaultOutputFileNameMapping(String defaultOutputFileNameMapping) {
        this.defaultOutputFileNameMapping = defaultOutputFileNameMapping;
    }

    public MavenProject getModuleProject() {
        return this.moduleProject;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    public Artifact getModuleArtifact() {
        return this.moduleArtifact;
    }

    static {
        ArrayList<String> nonArch = new ArrayList<String>();
        nonArch.add("pom");
        NON_ARCHIVE_DEPENDENCY_TYPES = Collections.unmodifiableList(nonArch);
    }
}

