/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Plugin;
import org.apache.maven.mercury.repository.metadata.PluginOperand;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class AddPluginOperation
implements MetadataOperation {
    private static final Language LANG = new DefaultLanguage(AddPluginOperation.class);
    private Plugin plugin;
    private static PluginComparator pluginComparator;

    public AddPluginOperation(PluginOperand data) throws MetadataException {
        pluginComparator = new PluginComparator();
        this.setOperand(data);
    }

    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof PluginOperand)) {
            throw new MetadataException(LANG.getMessage("bad.operand", new String[]{"PluginOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.plugin = ((PluginOperand)data).getOperand();
    }

    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        List plugins = metadata.getPlugins();
        for (Plugin p : plugins) {
            if (!p.getArtifactId().equals(this.plugin.getArtifactId())) continue;
            return false;
        }
        plugins.add(this.plugin);
        Collections.sort(plugins, pluginComparator);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PluginComparator
    implements Comparator<Plugin> {
        PluginComparator() {
        }

        @Override
        public int compare(Plugin p1, Plugin p2) {
            if (p1 == null || p2 == null) {
                throw new IllegalArgumentException(LANG.getMessage("null.plugin.to.compare", new String[0]));
            }
            if (p1.getArtifactId() == null || p2.getArtifactId() == null) {
                throw new IllegalArgumentException(LANG.getMessage("null.plugin.artifactId.to.compare", new String[]{p1.getArtifactId(), p2.getArtifactId()}));
            }
            return p1.getArtifactId().compareTo(p2.getArtifactId());
        }
    }
}

