/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import org.apache.maven.model.Model;

class ModelProblemUtils {
    ModelProblemUtils() {
    }

    public static String toSourceHint(Model model) {
        if (model == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(192);
        buffer.append(ModelProblemUtils.toId(model));
        File pomFile = model.getPomFile();
        if (pomFile != null) {
            buffer.append(" (").append(pomFile).append(")");
        }
        return buffer.toString();
    }

    public static String toPath(Model model) {
        File pomFile;
        String path = "";
        if (model != null && (pomFile = model.getPomFile()) != null) {
            path = pomFile.getAbsolutePath();
        }
        return path;
    }

    public static String toId(Model model) {
        if (model == null) {
            return "";
        }
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    public static String toId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(96);
        buffer.append(groupId != null && groupId.length() > 0 ? groupId : "[unknown-group-id]");
        buffer.append(':');
        buffer.append(artifactId != null && artifactId.length() > 0 ? artifactId : "[unknown-artifact-id]");
        buffer.append(':');
        buffer.append(version != null && version.length() > 0 ? version : "[unknown-version]");
        return buffer.toString();
    }
}

