package org.apache.maven.doxia.siterenderer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

/**
 * Renders a page with Doxia.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: DoxiaDocumentRenderer.java 1588724 2014-04-20 08:13:14Z hboutemy $
 */
public class DoxiaDocumentRenderer
    implements DocumentRenderer
{
    private RenderingContext renderingContext;

    /**
     * Constructor.
     *
     * @param renderingContext the document's RenderingContext to use.
     */
    public DoxiaDocumentRenderer( RenderingContext renderingContext )
    {
        this.renderingContext = renderingContext;
    }

    /** {@inheritDoc} */
    public void renderDocument( Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext )
        throws RendererException, FileNotFoundException, UnsupportedEncodingException
    {
        renderer.renderDocument( writer, renderingContext, siteRenderingContext );
    }

    /** {@inheritDoc} */
    public String getOutputName()
    {
        return renderingContext.getOutputName();
    }

    /** {@inheritDoc} */
    public RenderingContext getRenderingContext()
    {
        return renderingContext;
    }

    /** {@inheritDoc} */
    public boolean isOverwrite()
    {
        return false;
    }

}
