/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.SourceGraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class TableSourceNode<K, V>
extends SourceGraphNode<K, V> {
    private final MaterializedInternal<K, V, ?> materializedInternal;
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final String sourceName;
    private final boolean isGlobalKTable;
    private boolean shouldReuseSourceTopicForChangelog = false;

    private TableSourceNode(String nodeName, String sourceName, String topic, ConsumedInternal<K, V> consumedInternal, MaterializedInternal<K, V, ?> materializedInternal, ProcessorParameters<K, V, ?, ?> processorParameters, boolean isGlobalKTable) {
        super(nodeName, Collections.singletonList(topic), consumedInternal);
        this.sourceName = sourceName;
        this.isGlobalKTable = isGlobalKTable;
        this.processorParameters = processorParameters;
        this.materializedInternal = materializedInternal;
    }

    public void reuseSourceTopicForChangeLog(boolean shouldReuseSourceTopicForChangelog) {
        this.shouldReuseSourceTopicForChangelog = shouldReuseSourceTopicForChangelog;
    }

    @Override
    public String toString() {
        return "TableSourceNode{materializedInternal=" + this.materializedInternal + ", processorParameters=" + this.processorParameters + ", sourceName='" + this.sourceName + '\'' + ", isGlobalKTable=" + this.isGlobalKTable + "} " + super.toString();
    }

    public static <K, V> TableSourceNodeBuilder<K, V> tableSourceNodeBuilder() {
        return new TableSourceNodeBuilder();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String topicName;
        if (this.topicNames().isPresent()) {
            Iterator<String> topicNames = this.topicNames().get().iterator();
            topicName = topicNames.next();
            if (topicNames.hasNext()) {
                throw new IllegalStateException("A table source node must have a single topic as input");
            }
        } else {
            throw new IllegalStateException("A table source node must have a single topic as input");
        }
        StoreBuilder<?> storeBuilder = new KeyValueStoreMaterializer<K, V>(this.materializedInternal).materialize();
        if (this.isGlobalKTable) {
            topologyBuilder.addGlobalStore(storeBuilder, this.sourceName, this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), topicName, this.processorParameters.processorName(), this.processorParameters.processorSupplier());
        } else {
            topologyBuilder.addSource(this.consumedInternal().offsetResetPolicy(), this.sourceName, this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), topicName);
            topologyBuilder.addProcessor(this.processorParameters.processorName(), this.processorParameters.processorSupplier(), this.sourceName);
            KTableSource tableSource = (KTableSource)this.processorParameters.processorSupplier();
            if (tableSource.materialized()) {
                topologyBuilder.addStateStore(storeBuilder, this.nodeName());
                if (this.shouldReuseSourceTopicForChangelog) {
                    storeBuilder.withLoggingDisabled();
                    topologyBuilder.connectSourceStoreAndTopic(storeBuilder.name(), topicName);
                }
            }
        }
    }

    public static final class TableSourceNodeBuilder<K, V> {
        private String nodeName;
        private String sourceName;
        private String topic;
        private ConsumedInternal<K, V> consumedInternal;
        private MaterializedInternal<K, V, ?> materializedInternal;
        private ProcessorParameters<K, V, ?, ?> processorParameters;
        private boolean isGlobalKTable = false;

        private TableSourceNodeBuilder() {
        }

        public TableSourceNodeBuilder<K, V> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public TableSourceNodeBuilder<K, V> withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public TableSourceNodeBuilder<K, V> withMaterializedInternal(MaterializedInternal<K, V, ?> materializedInternal) {
            this.materializedInternal = materializedInternal;
            return this;
        }

        public TableSourceNodeBuilder<K, V> withConsumedInternal(ConsumedInternal<K, V> consumedInternal) {
            this.consumedInternal = consumedInternal;
            return this;
        }

        public TableSourceNodeBuilder<K, V> withProcessorParameters(ProcessorParameters<K, V, ?, ?> processorParameters) {
            this.processorParameters = processorParameters;
            return this;
        }

        public TableSourceNodeBuilder<K, V> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public TableSourceNodeBuilder<K, V> isGlobalKTable(boolean isGlobalKTable) {
            this.isGlobalKTable = isGlobalKTable;
            return this;
        }

        public TableSourceNode<K, V> build() {
            return new TableSourceNode(this.nodeName, this.sourceName, this.topic, this.consumedInternal, this.materializedInternal, this.processorParameters, this.isGlobalKTable);
        }
    }
}

