/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandLineUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandLineUtilsTest {
    Properties props = new Properties();
    OptionParser parser = new OptionParser(false);
    OptionSpec<String> stringOpt;
    OptionSpec<Integer> intOpt;
    OptionSpec<String> stringOptOptionalArg;
    OptionSpec<Integer> intOptOptionalArg;
    OptionSpec<String> stringOptOptionalArgNoDefault;
    OptionSpec<Integer> intOptOptionalArgNoDefault;

    @Test
    public void testParseEmptyArg() {
        List<String> argArray = Arrays.asList("my.empty.property=");
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLineUtils.parseKeyValueArgs((List)argArray, (boolean)false));
    }

    @Test
    public void testParseEmptyArgWithNoDelimiter() {
        List<String> argArray = Arrays.asList("my.empty.property");
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLineUtils.parseKeyValueArgs((List)argArray, (boolean)false));
    }

    @Test
    public void testParseEmptyArgAsValid() {
        List<String> argArray = Arrays.asList("my.empty.property=", "my.empty.property1");
        Properties props = CommandLineUtils.parseKeyValueArgs(argArray);
        Assertions.assertEquals((Object)props.getProperty("my.empty.property"), (Object)"", (String)"Value of a key with missing value should be an empty string");
        Assertions.assertEquals((Object)props.getProperty("my.empty.property1"), (Object)"", (String)"Value of a key with missing value with no delimiter should be an empty string");
    }

    @Test
    public void testParseSingleArg() {
        List<String> argArray = Arrays.asList("my.property=value");
        Properties props = CommandLineUtils.parseKeyValueArgs(argArray);
        Assertions.assertEquals((Object)props.getProperty("my.property"), (Object)"value", (String)"Value of a single property should be 'value'");
    }

    @Test
    public void testParseArgs() {
        List<String> argArray = Arrays.asList("first.property=first", "second.property=second");
        Properties props = CommandLineUtils.parseKeyValueArgs(argArray);
        Assertions.assertEquals((Object)props.getProperty("first.property"), (Object)"first", (String)"Value of first property should be 'first'");
        Assertions.assertEquals((Object)props.getProperty("second.property"), (Object)"second", (String)"Value of second property should be 'second'");
    }

    @Test
    public void testParseArgsWithMultipleDelimiters() {
        List<String> argArray = Arrays.asList("first.property==first", "second.property=second=", "third.property=thi=rd");
        Properties props = CommandLineUtils.parseKeyValueArgs(argArray);
        Assertions.assertEquals((Object)props.getProperty("first.property"), (Object)"=first", (String)"Value of first property should be '=first'");
        Assertions.assertEquals((Object)props.getProperty("second.property"), (Object)"second=", (String)"Value of second property should be 'second='");
        Assertions.assertEquals((Object)props.getProperty("third.property"), (Object)"thi=rd", (String)"Value of second property should be 'thi=rd'");
    }

    private void setUpOptions() {
        this.stringOpt = this.parser.accepts("str").withRequiredArg().ofType(String.class).defaultsTo((Object)"default-string", (Object[])new String[0]);
        this.intOpt = this.parser.accepts("int").withRequiredArg().ofType(Integer.class).defaultsTo((Object)100, (Object[])new Integer[0]);
        this.stringOptOptionalArg = this.parser.accepts("str-opt").withOptionalArg().ofType(String.class).defaultsTo((Object)"default-string-2", (Object[])new String[0]);
        this.intOptOptionalArg = this.parser.accepts("int-opt").withOptionalArg().ofType(Integer.class).defaultsTo((Object)200, (Object[])new Integer[0]);
        this.stringOptOptionalArgNoDefault = this.parser.accepts("str-opt-nodef").withOptionalArg().ofType(String.class);
        this.intOptOptionalArgNoDefault = this.parser.accepts("int-opt-nodef").withOptionalArg().ofType(Integer.class);
    }

    @Test
    public void testMaybeMergeOptionsOverwriteExisting() {
        this.setUpOptions();
        this.props.put("skey", "existing-string");
        this.props.put("ikey", "300");
        this.props.put("sokey", "existing-string-2");
        this.props.put("iokey", "400");
        this.props.put("sondkey", "existing-string-3");
        this.props.put("iondkey", "500");
        OptionSet options = this.parser.parse(new String[]{"--str", "some-string", "--int", "600", "--str-opt", "some-string-2", "--int-opt", "700", "--str-opt-nodef", "some-string-3", "--int-opt-nodef", "800"});
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"skey", (OptionSet)options, this.stringOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"ikey", (OptionSet)options, this.intOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sokey", (OptionSet)options, this.stringOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iokey", (OptionSet)options, this.intOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sondkey", (OptionSet)options, this.stringOptOptionalArgNoDefault);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iondkey", (OptionSet)options, this.intOptOptionalArgNoDefault);
        Assertions.assertEquals((Object)"some-string", (Object)this.props.get("skey"));
        Assertions.assertEquals((Object)"600", (Object)this.props.get("ikey"));
        Assertions.assertEquals((Object)"some-string-2", (Object)this.props.get("sokey"));
        Assertions.assertEquals((Object)"700", (Object)this.props.get("iokey"));
        Assertions.assertEquals((Object)"some-string-3", (Object)this.props.get("sondkey"));
        Assertions.assertEquals((Object)"800", (Object)this.props.get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultOverwriteExisting() {
        this.setUpOptions();
        this.props.put("sokey", "existing-string");
        this.props.put("iokey", "300");
        this.props.put("sondkey", "existing-string-2");
        this.props.put("iondkey", "400");
        OptionSet options = this.parser.parse(new String[]{"--str-opt", "--int-opt", "--str-opt-nodef", "--int-opt-nodef"});
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sokey", (OptionSet)options, this.stringOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iokey", (OptionSet)options, this.intOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sondkey", (OptionSet)options, this.stringOptOptionalArgNoDefault);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iondkey", (OptionSet)options, this.intOptOptionalArgNoDefault);
        Assertions.assertEquals((Object)"default-string-2", (Object)this.props.get("sokey"));
        Assertions.assertEquals((Object)"200", (Object)this.props.get("iokey"));
        Assertions.assertNull((Object)this.props.get("sondkey"));
        Assertions.assertNull((Object)this.props.get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultValueIfNotExist() {
        this.setUpOptions();
        OptionSet options = this.parser.parse(new String[0]);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"skey", (OptionSet)options, this.stringOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"ikey", (OptionSet)options, this.intOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sokey", (OptionSet)options, this.stringOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iokey", (OptionSet)options, this.intOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sondkey", (OptionSet)options, this.stringOptOptionalArgNoDefault);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iondkey", (OptionSet)options, this.intOptOptionalArgNoDefault);
        Assertions.assertEquals((Object)"default-string", (Object)this.props.get("skey"));
        Assertions.assertEquals((Object)"100", (Object)this.props.get("ikey"));
        Assertions.assertEquals((Object)"default-string-2", (Object)this.props.get("sokey"));
        Assertions.assertEquals((Object)"200", (Object)this.props.get("iokey"));
        Assertions.assertNull((Object)this.props.get("sondkey"));
        Assertions.assertNull((Object)this.props.get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsNotOverwriteExisting() {
        this.setUpOptions();
        this.props.put("skey", "existing-string");
        this.props.put("ikey", "300");
        this.props.put("sokey", "existing-string-2");
        this.props.put("iokey", "400");
        this.props.put("sondkey", "existing-string-3");
        this.props.put("iondkey", "500");
        OptionSet options = this.parser.parse(new String[0]);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"skey", (OptionSet)options, this.stringOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"ikey", (OptionSet)options, this.intOpt);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sokey", (OptionSet)options, this.stringOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iokey", (OptionSet)options, this.intOptOptionalArg);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"sondkey", (OptionSet)options, this.stringOptOptionalArgNoDefault);
        CommandLineUtils.maybeMergeOptions((Properties)this.props, (String)"iondkey", (OptionSet)options, this.intOptOptionalArgNoDefault);
        Assertions.assertEquals((Object)"existing-string", (Object)this.props.get("skey"));
        Assertions.assertEquals((Object)"300", (Object)this.props.get("ikey"));
        Assertions.assertEquals((Object)"existing-string-2", (Object)this.props.get("sokey"));
        Assertions.assertEquals((Object)"400", (Object)this.props.get("iokey"));
        Assertions.assertEquals((Object)"existing-string-3", (Object)this.props.get("sondkey"));
        Assertions.assertEquals((Object)"500", (Object)this.props.get("iondkey"));
    }
}

