/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.serialization.Deserializer;

public class MockDeserializer
implements ClusterResourceListener,
Deserializer<byte[]> {
    public static AtomicInteger initCount = new AtomicInteger(0);
    public static AtomicInteger closeCount = new AtomicInteger(0);
    public static AtomicReference<ClusterResource> clusterMeta = new AtomicReference();
    public static ClusterResource noClusterId = new ClusterResource("no_cluster_id");
    public static AtomicReference<ClusterResource> clusterIdBeforeDeserialize = new AtomicReference<ClusterResource>(noClusterId);

    public static void resetStaticVariables() {
        initCount = new AtomicInteger(0);
        closeCount = new AtomicInteger(0);
        clusterMeta = new AtomicReference();
        clusterIdBeforeDeserialize = new AtomicReference<ClusterResource>(noClusterId);
    }

    public MockDeserializer() {
        initCount.incrementAndGet();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] deserialize(String topic, byte[] data) {
        clusterIdBeforeDeserialize.compareAndSet(noClusterId, clusterMeta.get());
        return data;
    }

    public void close() {
        closeCount.incrementAndGet();
    }

    public void onUpdate(ClusterResource clusterResource) {
        clusterMeta.set(clusterResource);
    }
}

