/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.Assert;
import org.junit.Test;

public class SanitizerTest {
    @Test
    public void testSanitize() throws UnsupportedEncodingException {
        String principal = "CN=Some characters !@#$%&*()_-+=';:,/~";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertTrue((boolean)sanitizedPrincipal.replace('%', '_').matches("[a-zA-Z0-9\\._\\-]+"));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
    }

    @Test
    public void testJmxSanitize() throws MalformedObjectNameException {
        int unquoted = 0;
        for (int i = 0; i < 65536; ++i) {
            char c = (char)i;
            String value = "value" + c;
            String jmxSanitizedValue = Sanitizer.jmxSanitize((String)value);
            if (jmxSanitizedValue.equals(value)) {
                ++unquoted;
            }
            this.verifyJmx(jmxSanitizedValue, i);
            String encodedValue = Sanitizer.sanitize((String)value);
            this.verifyJmx(encodedValue, i);
            Assert.assertEquals((Object)encodedValue, (Object)Sanitizer.jmxSanitize((String)encodedValue));
        }
        Assert.assertEquals((long)68L, (long)unquoted);
    }

    private void verifyJmx(String sanitizedValue, int c) throws MalformedObjectNameException {
        TestStat mbean = new TestStat();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("test:key=" + sanitizedValue);
        try {
            server.registerMBean(mbean, objectName);
            server.unregisterMBean(objectName);
        }
        catch (MBeanException | OperationsException e) {
            Assert.fail((String)("Could not register char=\\u" + c));
        }
    }

    public class TestStat
    implements TestStatMBean {
        @Override
        public int getValue() {
            return 1;
        }
    }

    public static interface TestStatMBean {
        public int getValue();
    }
}

