/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Cancellable;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class ResultBoundedCompletionService<V> {
    private final RpcRetryingCallerFactory retryingCallerFactory;
    private final Executor executor;
    private final QueueingFuture<V>[] tasks;
    private volatile QueueingFuture<V> completed = null;
    private volatile boolean cancelled = false;

    public ResultBoundedCompletionService(RpcRetryingCallerFactory retryingCallerFactory, Executor executor, int maxTasks) {
        this.retryingCallerFactory = retryingCallerFactory;
        this.executor = executor;
        this.tasks = new QueueingFuture[maxTasks];
    }

    public void submit(RetryingCallable<V> task, int callTimeout, int id) {
        QueueingFuture<V> newFuture = new QueueingFuture<V>(task, callTimeout);
        this.executor.execute(Trace.wrap(newFuture));
        this.tasks[id] = newFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueingFuture<V> take() throws InterruptedException {
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            while (this.completed == null && !this.cancelled) {
                this.tasks.wait();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueingFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            if (this.completed == null && !this.cancelled) {
                unit.timedWait(this.tasks, timeout);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            this.cancelled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (QueueingFuture<V> future : this.tasks) {
                if (future == null) continue;
                future.cancel(true);
            }
            return;
        }
    }

    class QueueingFuture<T>
    implements RunnableFuture<T> {
        private final RetryingCallable<T> future;
        private T result = null;
        private ExecutionException exeEx = null;
        private volatile boolean cancelled = false;
        private final int callTimeout;
        private final RpcRetryingCaller<T> retryingCaller;
        private boolean resultObtained = false;

        public QueueingFuture(RetryingCallable<T> future, int callTimeout) {
            this.future = future;
            this.callTimeout = callTimeout;
            this.retryingCaller = ResultBoundedCompletionService.this.retryingCallerFactory.newCaller();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!this.cancelled) {
                    this.result = this.retryingCaller.callWithRetries(this.future, this.callTimeout);
                    this.resultObtained = true;
                }
            }
            catch (Throwable t) {
                this.exeEx = new ExecutionException(t);
            }
            finally {
                QueueingFuture[] queueingFutureArray = ResultBoundedCompletionService.this.tasks;
                synchronized (queueingFutureArray) {
                    if (!this.cancelled && ResultBoundedCompletionService.this.completed == null) {
                        ResultBoundedCompletionService.this.completed = this;
                    }
                    ResultBoundedCompletionService.this.tasks.notify();
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.resultObtained || this.exeEx != null) {
                return false;
            }
            this.retryingCaller.cancel();
            if (this.future instanceof Cancellable) {
                ((Cancellable)((Object)this.future)).cancel();
            }
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.resultObtained || this.exeEx != null;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(1000L, TimeUnit.DAYS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("You did wait for 1000 days here?", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            QueueingFuture[] queueingFutureArray = ResultBoundedCompletionService.this.tasks;
            synchronized (queueingFutureArray) {
                if (this.resultObtained) {
                    return this.result;
                }
                if (this.exeEx != null) {
                    throw this.exeEx;
                }
                unit.timedWait(ResultBoundedCompletionService.this.tasks, timeout);
            }
            if (this.resultObtained) {
                return this.result;
            }
            if (this.exeEx != null) {
                throw this.exeEx;
            }
            throw new TimeoutException("timeout=" + timeout + ", " + (Object)((Object)unit));
        }
    }
}

