/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;

public class AuthFilter
extends AuthenticationFilter {
    private static final String CONF_PREFIX = "dfs.web.authentication.";

    protected Properties getConfiguration(String prefix, FilterConfig config) throws ServletException {
        Properties p = super.getConfiguration(CONF_PREFIX, config);
        p.setProperty("type", UserGroupInformation.isSecurityEnabled() ? "kerberos" : "simple");
        p.setProperty("simple.anonymous.allowed", "true");
        p.setProperty("cookie.path", "/");
        return p;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = AuthFilter.toLowerCase((HttpServletRequest)request);
        String tokenString = httpRequest.getParameter("delegation");
        if (tokenString != null) {
            filterChain.doFilter((ServletRequest)httpRequest, response);
            return;
        }
        super.doFilter((ServletRequest)httpRequest, response, filterChain);
    }

    private static HttpServletRequest toLowerCase(HttpServletRequest request) {
        Map original = request.getParameterMap();
        if (!ParamFilter.containsUpperCase(original.keySet())) {
            return request;
        }
        final HashMap m = new HashMap();
        for (Map.Entry entry : original.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            ArrayList<String> strings = (ArrayList<String>)m.get(key);
            if (strings == null) {
                strings = new ArrayList<String>();
                m.put(key, strings);
            }
            for (String v : (String[])entry.getValue()) {
                strings.add(v);
            }
        }
        return new HttpServletRequestWrapper(request){
            private Map<String, String[]> parameters;
            {
                super(x0);
                this.parameters = null;
            }

            public Map<String, String[]> getParameterMap() {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, String[]>();
                    for (Map.Entry entry : m.entrySet()) {
                        List a = (List)entry.getValue();
                        this.parameters.put((String)entry.getKey(), a.toArray(new String[a.size()]));
                    }
                }
                return this.parameters;
            }

            public String getParameter(String name) {
                List a = (List)m.get(name);
                return a == null ? null : (String)a.get(0);
            }

            public String[] getParameterValues(String name) {
                return this.getParameterMap().get(name);
            }

            public Enumeration<String> getParameterNames() {
                final Iterator i = m.keySet().iterator();
                return new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return i.hasNext();
                    }

                    @Override
                    public String nextElement() {
                        return (String)i.next();
                    }
                };
            }
        };
    }
}

