/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.BlockStorageLocationUtil;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LeaseRenewer;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.SocketCache;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferEncryptor;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DFSClient
implements Closeable {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    public static final long SERVER_DEFAULTS_VALIDITY_PERIOD = 3600000L;
    static final int TCP_WINDOW_SIZE = 131072;
    final ClientProtocol namenode;
    private Text dtService;
    final UserGroupInformation ugi;
    volatile boolean clientRunning = true;
    volatile long lastLeaseRenewal;
    private volatile FsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    final String clientName;
    Configuration conf;
    SocketFactory socketFactory;
    final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    final FileSystem.Statistics stats;
    final int hdfsTimeout;
    private final String authority;
    final SocketCache socketCache;
    final Conf dfsClientConf;
    private Random r = new Random();
    private SocketAddress[] localInterfaceAddrs;
    private DataEncryptionKey encryptionKey;
    private final Map<String, DFSOutputStream> filesBeingWritten = new HashMap<String, DFSOutputStream>();
    private boolean shortCircuitLocalReads;
    private static Map<String, Boolean> localAddrMap = Collections.synchronizedMap(new HashMap());

    Conf getConf() {
        return this.dfsClientConf;
    }

    @Deprecated
    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress address, Configuration conf) throws IOException {
        this(NameNode.getUri(address), conf);
    }

    public DFSClient(URI nameNodeUri, Configuration conf) throws IOException {
        this(nameNodeUri, conf, null);
    }

    public DFSClient(URI nameNodeUri, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this(nameNodeUri, null, conf, stats);
    }

    DFSClient(URI nameNodeUri, ClientProtocol rpcNamenode, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.dfsClientConf = new Conf(conf);
        this.conf = conf;
        this.stats = stats;
        this.socketFactory = NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class);
        this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
        this.hdfsTimeout = Client.getTimeout((Configuration)conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.authority = nameNodeUri == null ? "null" : nameNodeUri.getAuthority();
        this.clientName = "DFSClient_" + this.dfsClientConf.taskId + "_" + DFSUtil.getRandom().nextInt() + "_" + Thread.currentThread().getId();
        if (rpcNamenode != null) {
            Preconditions.checkArgument((nameNodeUri == null ? 1 : 0) != 0);
            this.namenode = rpcNamenode;
            this.dtService = null;
        } else {
            Preconditions.checkArgument((nameNodeUri != null ? 1 : 0) != 0, (Object)"null URI");
            NameNodeProxies.ProxyAndInfo<ClientProtocol> proxyInfo = NameNodeProxies.createProxy(conf, nameNodeUri, ClientProtocol.class);
            this.dtService = proxyInfo.getDelegationTokenService();
            this.namenode = proxyInfo.getProxy();
        }
        this.shortCircuitLocalReads = conf.getBoolean("dfs.client.read.shortcircuit", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Short circuit read is " + this.shortCircuitLocalReads));
        }
        Object[] localInterfaces = conf.getTrimmedStrings("dfs.client.local.interfaces");
        this.localInterfaceAddrs = DFSClient.getLocalInterfaceAddrs((String[])localInterfaces);
        if (LOG.isDebugEnabled() && 0 != localInterfaces.length) {
            LOG.debug((Object)("Using local interfaces [" + Joiner.on((char)',').join(localInterfaces) + "] with addresses [" + Joiner.on((char)',').join((Object[])this.localInterfaceAddrs) + "]"));
        }
        this.socketCache = SocketCache.getInstance(this.dfsClientConf.socketCacheCapacity, this.dfsClientConf.socketCacheExpiry);
    }

    private static SocketAddress[] getLocalInterfaceAddrs(String[] interfaceNames) throws UnknownHostException {
        ArrayList<InetSocketAddress> localAddrs = new ArrayList<InetSocketAddress>();
        for (String interfaceName : interfaceNames) {
            if (InetAddresses.isInetAddress((String)interfaceName)) {
                localAddrs.add(new InetSocketAddress(interfaceName, 0));
                continue;
            }
            if (NetUtils.isValidSubnet((String)interfaceName)) {
                for (InetAddress addr : NetUtils.getIPs((String)interfaceName, (boolean)false)) {
                    localAddrs.add(new InetSocketAddress(addr, 0));
                }
                continue;
            }
            for (String ip : DNS.getIPs((String)interfaceName, (boolean)false)) {
                localAddrs.add(new InetSocketAddress(ip, 0));
            }
        }
        return localAddrs.toArray(new SocketAddress[localAddrs.size()]);
    }

    SocketAddress getRandomLocalInterfaceAddr() {
        if (this.localInterfaceAddrs.length == 0) {
            return null;
        }
        int idx = this.r.nextInt(this.localInterfaceAddrs.length);
        SocketAddress addr = this.localInterfaceAddrs[idx];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using local interface " + addr));
        }
        return addr;
    }

    int getMaxBlockAcquireFailures() {
        return this.dfsClientConf.maxBlockAcquireFailures;
    }

    int getDatanodeWriteTimeout(int numNodes) {
        return this.dfsClientConf.confTime > 0 ? this.dfsClientConf.confTime + HdfsServerConstants.WRITE_TIMEOUT_EXTENSION * numNodes : 0;
    }

    int getDatanodeReadTimeout(int numNodes) {
        return this.dfsClientConf.socketTimeout > 0 ? HdfsServerConstants.READ_TIMEOUT_EXTENSION * numNodes + this.dfsClientConf.socketTimeout : 0;
    }

    int getHdfsTimeout() {
        return this.hdfsTimeout;
    }

    String getClientName() {
        return this.clientName;
    }

    boolean connectToDnViaHostname() {
        return this.dfsClientConf.connectToDnViaHostname;
    }

    void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    public LeaseRenewer getLeaseRenewer() throws IOException {
        return LeaseRenewer.getInstance(this.authority, this.ugi, this);
    }

    private void beginFileLease(String src, DFSOutputStream out) throws IOException {
        this.getLeaseRenewer().put(src, out, this);
    }

    void endFileLease(String src) throws IOException {
        this.getLeaseRenewer().closeFile(src, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFileBeingWritten(String src, DFSOutputStream out) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.put(src, out);
            if (this.lastLeaseRenewal == 0L) {
                this.updateLastLeaseRenewal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBeingWritten(String src) {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            this.filesBeingWritten.remove(src);
            if (this.filesBeingWritten.isEmpty()) {
                this.lastLeaseRenewal = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFilesBeingWrittenEmpty() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            return this.filesBeingWritten.isEmpty();
        }
    }

    boolean isClientRunning() {
        return this.clientRunning;
    }

    long getLastLeaseRenewal() {
        return this.lastLeaseRenewal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastLeaseRenewal() {
        Map<String, DFSOutputStream> map = this.filesBeingWritten;
        synchronized (map) {
            if (this.filesBeingWritten.isEmpty()) {
                return;
            }
            this.lastLeaseRenewal = Time.now();
        }
    }

    boolean renewLease() throws IOException {
        if (this.clientRunning && !this.isFilesBeingWrittenEmpty()) {
            try {
                this.namenode.renewLease(this.clientName);
                this.updateLastLeaseRenewal();
                return true;
            }
            catch (IOException e) {
                long elapsed = Time.now() - this.getLastLeaseRenewal();
                if (elapsed > 3600000L) {
                    LOG.warn((Object)("Failed to renew lease for " + this.clientName + " for " + elapsed / 1000L + " seconds (>= soft-limit =" + 3600L + " seconds.) " + "Closing all files being written ..."), (Throwable)e);
                    this.closeAllFilesBeingWritten(true);
                }
                throw e;
            }
        }
        return false;
    }

    void closeConnectionToNamenode() {
        RPC.stopProxy((Object)this.namenode);
    }

    void abort() {
        this.clientRunning = false;
        this.closeAllFilesBeingWritten(true);
        try {
            this.getLeaseRenewer().closeClient(this);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Exception occurred while aborting the client " + ioe));
        }
        this.closeConnectionToNamenode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllFilesBeingWritten(boolean abort) {
        while (true) {
            DFSOutputStream out;
            String src;
            Map<String, DFSOutputStream> map = this.filesBeingWritten;
            synchronized (map) {
                if (this.filesBeingWritten.isEmpty()) {
                    return;
                }
                src = this.filesBeingWritten.keySet().iterator().next();
                out = this.filesBeingWritten.remove(src);
            }
            if (out == null) continue;
            try {
                if (abort) {
                    out.abort();
                    continue;
                }
                out.close();
                continue;
            }
            catch (IOException ie) {
                LOG.error((Object)("Failed to " + (abort ? "abort" : "close") + " file " + src), (Throwable)ie);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.clientRunning) {
            this.closeAllFilesBeingWritten(false);
            this.clientRunning = false;
            this.getLeaseRenewer().closeClient(this);
            this.closeConnectionToNamenode();
        }
    }

    public long getDefaultBlockSize() {
        return this.dfsClientConf.defaultBlockSize;
    }

    public long getBlockSize(String f) throws IOException {
        try {
            return this.namenode.getPreferredBlockSize(f);
        }
        catch (IOException ie) {
            LOG.warn((Object)"Problem getting block size", (Throwable)ie);
            throw ie;
        }
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        long now = Time.now();
        if (now - this.serverDefaultsLastUpdate > 3600000L) {
            this.serverDefaults = this.namenode.getServerDefaults();
            this.serverDefaultsLastUpdate = now;
        }
        return this.serverDefaults;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public String getCanonicalServiceName() {
        return this.dtService != null ? this.dtService.toString() : null;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        assert (this.dtService != null);
        Token<DelegationTokenIdentifier> token = this.namenode.getDelegationToken(renewer);
        token.setService(this.dtService);
        LOG.info((Object)("Created " + DelegationTokenIdentifier.stringifyToken(token)));
        return token;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Renewing " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            return token.renew(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    static BlockReader getLocalBlockReader(Configuration conf, String src, ExtendedBlock blk, Token<BlockTokenIdentifier> accessToken, DatanodeInfo chosenNode, int socketTimeout, long offsetIntoBlock, boolean connectToDnViaHostname) throws SecretManager.InvalidToken, IOException {
        try {
            return BlockReaderLocal.newBlockReader(conf, src, blk, accessToken, chosenNode, socketTimeout, offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, connectToDnViaHostname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    private static boolean isLocalAddress(InetSocketAddress targetAddr) {
        boolean local;
        InetAddress addr = targetAddr.getAddress();
        Boolean cached = localAddrMap.get(addr.getHostAddress());
        if (cached != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Address " + targetAddr + (cached != false ? " is local" : " is not local")));
            }
            return cached;
        }
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Address " + targetAddr + (local ? " is local" : " is not local")));
        }
        localAddrMap.put(addr.getHostAddress(), local);
        return local;
    }

    private static boolean tokenRefetchNeeded(IOException ex, InetSocketAddress targetAddr) {
        if (ex instanceof InvalidBlockTokenException || ex instanceof SecretManager.InvalidToken) {
            LOG.info((Object)("Access token was invalid when connecting to " + targetAddr + " : " + ex));
            return true;
        }
        return false;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(token)));
        try {
            token.cancel(this.conf);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("caught interrupted", ie);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.dfsClientConf.defaultReplication;
    }

    @VisibleForTesting
    public LocatedBlocks getLocatedBlocks(String src, long start, long length) throws IOException {
        return DFSClient.callGetBlockLocations(this.namenode, src, start, length);
    }

    static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        try {
            return namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    boolean recoverLease(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.recoverLease(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class});
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException, UnresolvedLinkException {
        LocatedBlocks blocks = this.getLocatedBlocks(src, start, length);
        BlockLocation[] locations = DFSUtil.locatedBlocks2Locations(blocks);
        BlockLocation[] hdfsLocations = new HdfsBlockLocation[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            hdfsLocations[i] = new HdfsBlockLocation(locations[i], blocks.get(i));
        }
        return hdfsLocations;
    }

    public BlockStorageLocation[] getBlockStorageLocations(List<BlockLocation> blockLocations) throws IOException, UnsupportedOperationException, InvalidBlockTokenException {
        if (!this.getConf().getHdfsBlocksMetadataEnabled) {
            throw new UnsupportedOperationException("Datanode-side support for getVolumeBlockLocations() must also be enabled in the client configuration.");
        }
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        for (BlockLocation loc : blockLocations) {
            if (!(loc instanceof HdfsBlockLocation)) {
                throw new ClassCastException("DFSClient#getVolumeBlockLocations expected to be passed HdfsBlockLocations");
            }
            HdfsBlockLocation hdfsLoc = (HdfsBlockLocation)loc;
            blocks.add(hdfsLoc.getLocatedBlock());
        }
        LinkedHashMap<DatanodeInfo, List<LocatedBlock>> datanodeBlocks = new LinkedHashMap<DatanodeInfo, List<LocatedBlock>>();
        for (LocatedBlock b : blocks) {
            for (DatanodeInfo info : b.getLocations()) {
                if (!datanodeBlocks.containsKey(info)) {
                    datanodeBlocks.put(info, new ArrayList());
                }
                List l = (List)datanodeBlocks.get(info);
                l.add(b);
            }
        }
        List<HdfsBlocksMetadata> metadatas = BlockStorageLocationUtil.queryDatanodesForHdfsBlocksMetadata(this.conf, datanodeBlocks, this.getConf().getFileBlockStorageLocationsNumThreads, this.getConf().getFileBlockStorageLocationsTimeout, this.getConf().connectToDnViaHostname);
        Map<LocatedBlock, List<VolumeId>> blockVolumeIds = BlockStorageLocationUtil.associateVolumeIdsWithBlocks(blocks, datanodeBlocks, metadatas);
        BlockStorageLocation[] volumeBlockLocations = BlockStorageLocationUtil.convertToVolumeBlockLocations(blocks, blockVolumeIds);
        return volumeBlockLocations;
    }

    public DFSInputStream open(String src) throws IOException, UnresolvedLinkException {
        return this.open(src, this.dfsClientConf.ioBufferSize, true, null);
    }

    @Deprecated
    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException, UnresolvedLinkException {
        return this.open(src, buffersize, verifyChecksum);
    }

    public DFSInputStream open(String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        return new DFSInputStream(this, src, buffersize, verifyChecksum);
    }

    public ClientProtocol getNamenode() {
        return this.namenode;
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.defaultReplication, this.dfsClientConf.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.dfsClientConf.defaultReplication, this.dfsClientConf.defaultBlockSize, progress);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.dfsClientConf.ioBufferSize);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getFileDefault(), overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication, blockSize, progress, buffersize, null);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.create(src, permission, flag, true, replication, blockSize, progress, buffersize, checksumOpt);
    }

    public DFSOutputStream create(String src, FsPermission permission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getFileDefault();
        }
        FsPermission masked = permission.applyUMask(this.dfsClientConf.uMask);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + masked));
        }
        DFSOutputStream result = DFSOutputStream.newStreamForCreate(this, src, masked, flag, createParent, replication, blockSize, progress, buffersize, this.dfsClientConf.createChecksum(checksumOpt));
        this.beginFileLease(src, result);
        return result;
    }

    private DFSOutputStream primitiveAppend(String src, EnumSet<CreateFlag> flag, int buffersize, Progressable progress) throws IOException {
        if (flag.contains(CreateFlag.APPEND)) {
            HdfsFileStatus stat = this.getFileInfo(src);
            if (stat == null) {
                if (!flag.contains(CreateFlag.CREATE)) {
                    throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
                }
                return null;
            }
            return this.callAppend(stat, src, buffersize, progress);
        }
        return null;
    }

    public DFSOutputStream primitiveCreate(String src, FsPermission absPermission, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, Options.ChecksumOpt checksumOpt) throws IOException, UnresolvedLinkException {
        this.checkOpen();
        CreateFlag.validate(flag);
        DFSOutputStream result = this.primitiveAppend(src, flag, buffersize, progress);
        if (result == null) {
            DataChecksum checksum = this.dfsClientConf.createChecksum(checksumOpt);
            result = DFSOutputStream.newStreamForCreate(this, src, absPermission, flag, createParent, replication, blockSize, progress, buffersize, checksum);
        }
        this.beginFileLease(src, result);
        return result;
    }

    public void createSymlink(String target, String link, boolean createParent) throws IOException {
        try {
            FsPermission dirPerm = FsPermission.getDefault().applyUMask(this.dfsClientConf.uMask);
            this.namenode.createSymlink(target, link, dirPerm, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public String getLinkTarget(String path) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getLinkTarget(path);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class});
        }
    }

    private DFSOutputStream callAppend(HdfsFileStatus stat, String src, int buffersize, Progressable progress) throws IOException {
        LocatedBlock lastBlock = null;
        try {
            lastBlock = this.namenode.append(src, this.clientName);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnsupportedOperationException.class, UnresolvedPathException.class});
        }
        return DFSOutputStream.newStreamForAppend(this, src, buffersize, progress, lastBlock, stat, this.dfsClientConf.createChecksum());
    }

    public HdfsDataOutputStream append(String src, int buffersize, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        DFSOutputStream out = this.append(src, buffersize, progress);
        return new HdfsDataOutputStream(out, statistics, out.getInitialLen());
    }

    private DFSOutputStream append(String src, int buffersize, Progressable progress) throws IOException {
        this.checkOpen();
        HdfsFileStatus stat = this.getFileInfo(src);
        if (stat == null) {
            throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + this.clientName);
        }
        DFSOutputStream result = this.callAppend(stat, src, buffersize, progress);
        this.beginFileLease(src, result);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.namenode.setReplication(src, replication);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.rename(src, dst);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void concat(String trg, String[] srcs) throws IOException {
        this.checkOpen();
        try {
            this.namenode.concat(trg, srcs);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public void rename(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkOpen();
        try {
            this.namenode.rename2(src, dst, options);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.namenode.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.delete(src, recursive);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    public DirectoryListing listPaths(String src, byte[] startAfter) throws IOException {
        return this.listPaths(src, startAfter, false);
    }

    public DirectoryListing listPaths(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getListing(src, startAfter, needLocation);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileLinkInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, UnresolvedPathException.class});
        }
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(String src) throws IOException {
        this.checkOpen();
        return DFSClient.getFileChecksum(src, this.clientName, this.namenode, this.socketFactory, this.dfsClientConf.socketTimeout, this.getDataEncryptionKey(), this.dfsClientConf.connectToDnViaHostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void clearDataEncryptionKey() {
        LOG.debug((Object)"Clearing encryption key");
        DFSClient dFSClient = this;
        synchronized (dFSClient) {
            this.encryptionKey = null;
        }
    }

    boolean shouldEncryptData() throws IOException {
        FsServerDefaults d = this.getServerDefaults();
        return d == null ? false : d.getEncryptDataTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        if (this.shouldEncryptData()) {
            DFSClient dFSClient = this;
            synchronized (dFSClient) {
                if (this.encryptionKey == null || this.encryptionKey.expiryDate < Time.now()) {
                    LOG.debug((Object)"Getting new encryption token from NN");
                    this.encryptionKey = this.namenode.getDataEncryptionKey();
                }
                return this.encryptionKey;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static MD5MD5CRC32FileChecksum getFileChecksum(String src, String clientName, ClientProtocol namenode, SocketFactory socketFactory, int socketTimeout, DataEncryptionKey encryptionKey, boolean connectToDnViaHostname) throws IOException {
        LocatedBlocks blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, Long.MAX_VALUE);
        if (null == blockLocations) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        List<LocatedBlock> locatedblocks = blockLocations.getLocatedBlocks();
        DataOutputBuffer md5out = new DataOutputBuffer();
        int bytesPerCRC = -1;
        DataChecksum.Type crcType = DataChecksum.Type.DEFAULT;
        long crcPerBlock = 0L;
        boolean refetchBlocks = false;
        int lastRetriedIndex = -1;
        for (int i = 0; i < locatedblocks.size(); ++i) {
            if (refetchBlocks) {
                blockLocations = DFSClient.callGetBlockLocations(namenode, src, 0L, Long.MAX_VALUE);
                if (null == blockLocations) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                locatedblocks = blockLocations.getLocatedBlocks();
                refetchBlocks = false;
            }
            LocatedBlock lb = locatedblocks.get(i);
            ExtendedBlock block = lb.getBlock();
            DatanodeInfo[] datanodes = lb.getLocations();
            int timeout = 3000 * datanodes.length + socketTimeout;
            boolean done = false;
            for (int j = 0; !done && j < datanodes.length; ++j) {
                DataInputStream in;
                DataOutputStream out;
                block30: {
                    out = null;
                    in = null;
                    try {
                        DataChecksum.Type ct;
                        IOStreamPair pair = DFSClient.connectToDN(socketFactory, connectToDnViaHostname, encryptionKey, datanodes[j], timeout);
                        out = new DataOutputStream(new BufferedOutputStream(pair.out, HdfsConstants.SMALL_BUFFER_SIZE));
                        in = new DataInputStream(pair.in);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("write to " + datanodes[j] + ": " + (Object)((Object)Op.BLOCK_CHECKSUM) + ", block=" + block));
                        }
                        new Sender(out).blockChecksum(block, lb.getBlockToken());
                        DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
                        if (reply.getStatus() != DataTransferProtos.Status.SUCCESS) {
                            if (reply.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                                throw new InvalidBlockTokenException();
                            }
                            throw new IOException("Bad response " + reply + " for block " + block + " from datanode " + datanodes[j]);
                        }
                        DataTransferProtos.OpBlockChecksumResponseProto checksumData = reply.getChecksumResponse();
                        int bpc = checksumData.getBytesPerCrc();
                        if (i == 0) {
                            bytesPerCRC = bpc;
                        } else if (bpc != bytesPerCRC) {
                            throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + bytesPerCRC);
                        }
                        long cpb = checksumData.getCrcPerBlock();
                        if (locatedblocks.size() > 1 && i == 0) {
                            crcPerBlock = cpb;
                        }
                        MD5Hash md5 = new MD5Hash(checksumData.getMd5().toByteArray());
                        md5.write((DataOutput)md5out);
                        if (checksumData.hasCrcType()) {
                            ct = PBHelper.convert(checksumData.getCrcType());
                        } else {
                            LOG.debug((Object)"Retrieving checksum from an earlier-version DataNode: inferring checksum by reading first byte");
                            ct = DFSClient.inferChecksumTypeByReading(clientName, socketFactory, socketTimeout, lb, datanodes[j], encryptionKey, connectToDnViaHostname);
                        }
                        if (i == 0) {
                            crcType = ct;
                        } else if (crcType != DataChecksum.Type.MIXED && crcType != ct) {
                            crcType = DataChecksum.Type.MIXED;
                        }
                        done = true;
                        if (!LOG.isDebugEnabled()) break block30;
                        if (i == 0) {
                            LOG.debug((Object)("set bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock));
                        }
                        LOG.debug((Object)("got reply from " + datanodes[j] + ": md5=" + md5));
                    }
                    catch (InvalidBlockTokenException ibte) {
                        block31: {
                            if (i <= lastRetriedIndex) break block31;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Got access token error in response to OP_BLOCK_CHECKSUM for file " + src + " for block " + block + " from datanode " + datanodes[j] + ". Will retry the block once."));
                            }
                            lastRetriedIndex = i--;
                            done = true;
                            refetchBlocks = true;
                            IOUtils.closeStream(in);
                            IOUtils.closeStream((Closeable)out);
                            break;
                        }
                        IOUtils.closeStream(in);
                        IOUtils.closeStream(out);
                        continue;
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("src=" + src + ", datanodes[" + j + "]=" + datanodes[j]), (Throwable)ie);
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeStream(in);
                                IOUtils.closeStream(out);
                                throw throwable;
                            }
                        }
                        IOUtils.closeStream((Closeable)in);
                        IOUtils.closeStream((Closeable)out);
                        continue;
                    }
                }
                IOUtils.closeStream((Closeable)in);
                IOUtils.closeStream((Closeable)out);
                continue;
            }
            if (done) continue;
            throw new IOException("Fail to get block MD5 for " + block);
        }
        MD5Hash fileMD5 = MD5Hash.digest((byte[])md5out.getData());
        switch (crcType) {
            case CRC32: {
                return new MD5MD5CRC32GzipFileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
            }
            case CRC32C: {
                return new MD5MD5CRC32CastagnoliFileChecksum(bytesPerCRC, crcPerBlock, fileMD5);
            }
        }
        if (locatedblocks.size() == 0) {
            return new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IOStreamPair connectToDN(SocketFactory socketFactory, boolean connectToDnViaHostname, DataEncryptionKey encryptionKey, DatanodeInfo dn, int timeout) throws IOException {
        boolean success = false;
        Socket sock = null;
        try {
            sock = socketFactory.createSocket();
            String dnAddr = dn.getXferAddr(connectToDnViaHostname);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connecting to datanode " + dnAddr));
            }
            NetUtils.connect((Socket)sock, (SocketAddress)NetUtils.createSocketAddr((String)dnAddr), (int)timeout);
            sock.setSoTimeout(timeout);
            OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock);
            SocketInputWrapper unbufIn = NetUtils.getInputStream((Socket)sock);
            IOStreamPair ret = encryptionKey != null ? DataTransferEncryptor.getEncryptedStreams(unbufOut, (InputStream)unbufIn, encryptionKey) : new IOStreamPair((InputStream)unbufIn, unbufOut);
            success = true;
            IOStreamPair iOStreamPair = ret;
            return iOStreamPair;
        }
        finally {
            if (!success) {
                IOUtils.closeSocket((Socket)sock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataChecksum.Type inferChecksumTypeByReading(String clientName, SocketFactory socketFactory, int socketTimeout, LocatedBlock lb, DatanodeInfo dn, DataEncryptionKey encryptionKey, boolean connectToDnViaHostname) throws IOException {
        DataChecksum.Type type;
        IOStreamPair pair = DFSClient.connectToDN(socketFactory, connectToDnViaHostname, encryptionKey, dn, socketTimeout);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(pair.out, HdfsConstants.SMALL_BUFFER_SIZE));
            DataInputStream in = new DataInputStream(pair.in);
            new Sender(out).readBlock(lb.getBlock(), lb.getBlockToken(), clientName, 0L, 1L, true);
            DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
            if (reply.getStatus() != DataTransferProtos.Status.SUCCESS) {
                if (reply.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                    throw new InvalidBlockTokenException();
                }
                throw new IOException("Bad response " + reply + " trying to read " + lb.getBlock() + " from datanode " + dn);
            }
            type = PBHelper.convert(reply.getReadOpChecksumInfo().getChecksum().getType());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{pair.in, pair.out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{pair.in, pair.out});
        return type;
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, SafeModeException.class, UnresolvedPathException.class});
        }
    }

    public FsStatus getDiskStatus() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return new FsStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long getMissingBlocksCount() throws IOException {
        return this.namenode.getStats()[5];
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.namenode.getStats()[3];
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.namenode.getStats()[4];
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        return this.namenode.listCorruptFileBlocks(path, cookie);
    }

    public DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.namenode.getDatanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.namenode.setSafeMode(action, isChecked);
    }

    void saveNamespace() throws AccessControlException, IOException {
        try {
            this.namenode.saveNamespace();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class});
        }
    }

    long rollEdits() throws AccessControlException, IOException {
        try {
            return this.namenode.rollEdits();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class});
        }
    }

    boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        return this.namenode.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namenode.setBalancerBandwidth(bandwidth);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    @Deprecated
    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null, true);
    }

    public boolean mkdirs(String src, FsPermission permission, boolean createParent) throws IOException {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(this.dfsClientConf.uMask);
        return this.primitiveMkdir(src, masked, createParent);
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission) throws IOException {
        return this.primitiveMkdir(src, absPermission, true);
    }

    public boolean primitiveMkdir(String src, FsPermission absPermission, boolean createParent) throws IOException {
        this.checkOpen();
        if (absPermission == null) {
            absPermission = FsPermission.getDefault().applyUMask(this.dfsClientConf.uMask);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(src + ": masked=" + absPermission));
        }
        try {
            return this.namenode.mkdirs(src, absPermission, createParent);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, InvalidPathException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, SafeModeException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        try {
            return this.namenode.getContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    void setQuota(String src, long namespaceQuota, long diskspaceQuota) throws IOException {
        if (namespaceQuota <= 0L && namespaceQuota != Long.MAX_VALUE && namespaceQuota != -1L || diskspaceQuota <= 0L && diskspaceQuota != Long.MAX_VALUE && diskspaceQuota != -1L) {
            throw new IllegalArgumentException("Invalid values for quota : " + namespaceQuota + " and " + diskspaceQuota);
        }
        try {
            this.namenode.setQuota(src, namespaceQuota, diskspaceQuota);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
        }
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setTimes(src, mtime, atime);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{AccessControlException.class, FileNotFoundException.class, UnresolvedPathException.class});
        }
    }

    boolean shouldTryShortCircuitRead(InetSocketAddress targetAddr) {
        return this.shortCircuitLocalReads && DFSClient.isLocalAddress(targetAddr);
    }

    void reportChecksumFailure(String file, ExtendedBlock blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ". Error repairing corrupt blocks. Bad blocks remain."), (Throwable)ie);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[clientName=" + this.clientName + ", ugi=" + this.ugi + "]";
    }

    void disableShortCircuit() {
        this.shortCircuitLocalReads = false;
    }

    @Deprecated
    public static class DFSDataInputStream
    extends HdfsDataInputStream {
        public DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals((Object)kind);
        }

        public long renew(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                return nn.renewDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException {
            Token<?> delToken = token;
            LOG.info((Object)("Cancelling " + DelegationTokenIdentifier.stringifyToken(delToken)));
            ClientProtocol nn = Renewer.getNNProxy(delToken, conf);
            try {
                nn.cancelDelegationToken(delToken);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
            }
        }

        private static ClientProtocol getNNProxy(Token<DelegationTokenIdentifier> token, Configuration conf) throws IOException {
            URI uri = HAUtil.getServiceUriFromToken(token);
            if (HAUtil.isTokenForLogicalUri(token) && !HAUtil.isLogicalUri(conf, uri)) {
                throw new IOException("Unable to map logical nameservice URI '" + uri + "' to a NameNode. Local configuration does not have " + "a failover proxy provider configured.");
            }
            NameNodeProxies.ProxyAndInfo<ClientProtocol> info = NameNodeProxies.createProxy(conf, uri, ClientProtocol.class);
            assert (info.getDelegationTokenService().equals((Object)token.getService())) : "Returned service '" + info.getDelegationTokenService().toString() + "' doesn't match expected service '" + token.getService().toString() + "'";
            return info.getProxy();
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        static {
            HdfsConfiguration.init();
        }
    }

    static class Conf {
        final int maxFailoverAttempts;
        final int failoverSleepBaseMillis;
        final int failoverSleepMaxMillis;
        final int maxBlockAcquireFailures;
        final int confTime;
        final int ioBufferSize;
        final Options.ChecksumOpt defaultChecksumOpt;
        final int writePacketSize;
        final int socketTimeout;
        final int socketCacheCapacity;
        final long socketCacheExpiry;
        final int timeWindow;
        final int nCachedConnRetry;
        final int nBlockWriteRetry;
        final int nBlockWriteLocateFollowingRetry;
        final long defaultBlockSize;
        final long prefetchSize;
        final short defaultReplication;
        final String taskId;
        final FsPermission uMask;
        final boolean useLegacyBlockReader;
        final boolean connectToDnViaHostname;
        final boolean getHdfsBlocksMetadataEnabled;
        final int getFileBlockStorageLocationsNumThreads;
        final int getFileBlockStorageLocationsTimeout;

        Conf(Configuration conf) {
            this.maxFailoverAttempts = conf.getInt("dfs.client.failover.max.attempts", 15);
            this.failoverSleepBaseMillis = conf.getInt("dfs.client.failover.sleep.base.millis", 500);
            this.failoverSleepMaxMillis = conf.getInt("dfs.client.failover.sleep.max.millis", 15000);
            this.maxBlockAcquireFailures = conf.getInt("dfs.client.max.block.acquire.failures", 3);
            this.confTime = conf.getInt("dfs.datanode.socket.write.timeout", HdfsServerConstants.WRITE_TIMEOUT);
            this.ioBufferSize = conf.getInt("io.file.buffer.size", 4096);
            this.defaultChecksumOpt = this.getChecksumOptFromConf(conf);
            this.socketTimeout = conf.getInt("dfs.client.socket-timeout", HdfsServerConstants.READ_TIMEOUT);
            this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
            this.defaultBlockSize = conf.getLongBytes("dfs.blocksize", 0x4000000L);
            this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
            this.taskId = conf.get("mapreduce.task.attempt.id", "NONMAPREDUCE");
            this.socketCacheCapacity = conf.getInt("dfs.client.socketcache.capacity", 16);
            this.socketCacheExpiry = conf.getLong("dfs.client.socketcache.expiryMsec", 120000L);
            this.prefetchSize = conf.getLong("dfs.client.read.prefetch.size", 10L * this.defaultBlockSize);
            this.timeWindow = conf.getInt("dfs.client.retry.window.base", 3000);
            this.nCachedConnRetry = conf.getInt("dfs.client.cached.conn.retry", 3);
            this.nBlockWriteRetry = conf.getInt("dfs.client.block.write.retries", 3);
            this.nBlockWriteLocateFollowingRetry = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5);
            this.uMask = FsPermission.getUMask((Configuration)conf);
            this.useLegacyBlockReader = conf.getBoolean("dfs.client.use.legacy.blockreader", false);
            this.connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
            this.getHdfsBlocksMetadataEnabled = conf.getBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", false);
            this.getFileBlockStorageLocationsNumThreads = conf.getInt("dfs.client.file-block-storage-locations.num-threads", 10);
            this.getFileBlockStorageLocationsTimeout = conf.getInt("dfs.client.file-block-storage-locations.timeout", 60);
        }

        private DataChecksum.Type getChecksumType(Configuration conf) {
            String checksum = conf.get("dfs.checksum.type", "CRC32C");
            try {
                return DataChecksum.Type.valueOf((String)checksum);
            }
            catch (IllegalArgumentException iae) {
                LOG.warn((Object)("Bad checksum type: " + checksum + ". Using default " + "CRC32C"));
                return DataChecksum.Type.valueOf((String)"CRC32C");
            }
        }

        private Options.ChecksumOpt getChecksumOptFromConf(Configuration conf) {
            DataChecksum.Type type = this.getChecksumType(conf);
            int bytesPerChecksum = conf.getInt("dfs.bytes-per-checksum", 512);
            return new Options.ChecksumOpt(type, bytesPerChecksum);
        }

        private DataChecksum createChecksum() throws IOException {
            return this.createChecksum(null);
        }

        private DataChecksum createChecksum(Options.ChecksumOpt userOpt) throws IOException {
            Options.ChecksumOpt myOpt = Options.ChecksumOpt.processChecksumOpt((Options.ChecksumOpt)this.defaultChecksumOpt, (Options.ChecksumOpt)userOpt);
            DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)myOpt.getChecksumType(), (int)myOpt.getBytesPerChecksum());
            if (dataChecksum == null) {
                throw new IOException("Invalid checksum type specified: " + myOpt.getChecksumType().name());
            }
            return dataChecksum;
        }
    }
}

