/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarFile;
import org.apache.openejb.loader.BasicURLClassPath;
import sun.misc.URLClassPath;

public class TomcatClassPath
extends BasicURLClassPath {
    private final ClassLoader commonLoader;
    private final ClassLoader serverLoader;
    private Method addRepositoryMethod;
    private Method addURLMethod;

    public TomcatClassPath() {
        this(TomcatClassPath.getCommonLoader(TomcatClassPath.getContextClassLoader()));
    }

    public TomcatClassPath(ClassLoader classLoader) {
        this.commonLoader = classLoader;
        try {
            this.addRepositoryMethod = this.getAddRepositoryMethod();
        }
        catch (Exception tomcat4Exception) {
            try {
                this.addURLMethod = this.getAddURLMethod();
            }
            catch (Exception tomcat5Exception) {
                throw new RuntimeException("Failed accessing classloader for Tomcat 5 or 6", tomcat5Exception);
            }
        }
        ClassLoader serverLoader = TomcatClassPath.getServerLoader(TomcatClassPath.getContextClassLoader());
        this.serverLoader = serverLoader != null && serverLoader != this.commonLoader ? serverLoader : null;
    }

    private static ClassLoader getCommonLoader(ClassLoader loader) {
        ClassLoader bootstrapCL;
        try {
            bootstrapCL = loader.loadClass("org.apache.catalina.startup.Bootstrap").getClassLoader();
        }
        catch (ClassNotFoundException e) {
            bootstrapCL = ClassLoader.getSystemClassLoader();
        }
        if (loader == bootstrapCL) {
            return loader;
        }
        while (loader.getParent() != bootstrapCL && loader.getParent() != null) {
            loader = loader.getParent();
        }
        return loader;
    }

    private static ClassLoader getServerLoader(ClassLoader loader) {
        try {
            return loader.loadClass("org.apache.catalina.Container").getClassLoader();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.serverLoader != null ? this.serverLoader : this.commonLoader;
    }

    public ClassLoader getCommonLoader() {
        return this.commonLoader;
    }

    public void addJarsToPath(File dir) throws Exception {
        String[] jarNames = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (jarNames == null) {
            return;
        }
        for (String jarName : jarNames) {
            this.addJarToPath(new File(dir, jarName).toURI().toURL());
        }
        this.rebuild();
    }

    public void addJarToPath(URL jar) throws Exception {
        this._addJarToPath(jar);
        this.rebuild();
    }

    public void _addJarToPath(URL jar) throws Exception {
        ClassLoader classLoader = this.commonLoader;
        if (this.serverLoader != null && this.useServerClassLoader(jar)) {
            classLoader = this.serverLoader;
        }
        if (this.addRepositoryMethod != null) {
            String path = jar.toExternalForm();
            this.addRepositoryMethod.invoke((Object)classLoader, path);
        } else {
            this.addURLMethod.invoke((Object)classLoader, jar);
        }
    }

    private boolean useServerClassLoader(URL jar) {
        try {
            URL url = TomcatClassPath.findResource("META-INF/org.apache.openejb.tomcat/ServerClassLoader", jar);
            return url != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void rebuild() {
        try {
            URLClassPath cp = this.getURLClassPath((URLClassLoader)this.getCommonLoader());
            URL[] urls = cp.getURLs();
            if (urls.length < 1) {
                return;
            }
            StringBuffer path = new StringBuffer(urls.length * 32);
            File s = new File(URLDecoder.decode(urls[0].getFile()));
            path.append(s.getPath());
            for (int i = 1; i < urls.length; ++i) {
                path.append(File.pathSeparator);
                s = new File(URLDecoder.decode(urls[i].getFile()));
                path.append(s.getPath());
            }
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Method getAddURLMethod() throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                Method method = null;
                try {
                    Class<URLClassLoader> clazz = URLClassLoader.class;
                    method = clazz.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return method;
                }
            }
        });
    }

    private Method getAddRepositoryMethod() throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Class<?> clazz = TomcatClassPath.this.getClassLoader().getClass();
                    Method method = clazz.getDeclaredMethod("addRepository", String.class);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception e2) {
                    throw (IllegalStateException)new IllegalStateException("Unable to find or access the addRepository method in StandardClassLoader").initCause(e2);
                }
            }
        });
    }

    private static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.length() > 0 && file.charAt(file.length() - 1) == '/';
    }

    private static URL findResource(String resourceName, URL ... search) {
        for (int i = 0; i < search.length; ++i) {
            URL currentUrl = search[i];
            if (currentUrl == null || currentUrl == null || TomcatClassPath.isDirectory(currentUrl) || currentUrl.getProtocol().equals("jar")) continue;
            try {
                currentUrl = new URL("jar", "", -1, currentUrl.toString() + "!/");
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            try {
                String protocol = currentUrl.getProtocol();
                if (protocol.equals("jar")) {
                    String entryName;
                    JarFile jarFile;
                    URL jarURL = ((JarURLConnection)currentUrl.openConnection()).getJarFileURL();
                    try {
                        JarURLConnection juc = (JarURLConnection)new URL("jar", "", jarURL.toExternalForm() + "!/").openConnection();
                        jarFile = juc.getJarFile();
                    }
                    catch (IOException e) {
                        search[i] = null;
                        throw e;
                    }
                    if (currentUrl.getFile().endsWith("!/")) {
                        entryName = resourceName;
                    } else {
                        String file = currentUrl.getFile();
                        int sepIdx = file.lastIndexOf("!/");
                        if (sepIdx == -1) {
                            search[i] = null;
                            continue;
                        }
                        StringBuffer sb = new StringBuffer(file.length() - (sepIdx += 2) + resourceName.length());
                        sb.append(file.substring(sepIdx));
                        sb.append(resourceName);
                        entryName = sb.toString();
                    }
                    if (entryName.equals("META-INF/") && jarFile.getEntry("META-INF/MANIFEST.MF") != null) {
                        return TomcatClassPath.targetURL(currentUrl, "META-INF/MANIFEST.MF");
                    }
                    if (jarFile.getEntry(entryName) == null) continue;
                    return TomcatClassPath.targetURL(currentUrl, resourceName);
                }
                if (protocol.equals("file")) {
                    String baseFile = currentUrl.getFile();
                    String host = currentUrl.getHost();
                    int hostLength = 0;
                    if (host != null) {
                        hostLength = host.length();
                    }
                    StringBuffer buf = new StringBuffer(2 + hostLength + baseFile.length() + resourceName.length());
                    if (hostLength > 0) {
                        buf.append("//").append(host);
                    }
                    buf.append(baseFile);
                    String fixedResName = resourceName;
                    while (fixedResName.startsWith("/") || fixedResName.startsWith("\\")) {
                        fixedResName = fixedResName.substring(1);
                    }
                    buf.append(fixedResName);
                    String filename = buf.toString();
                    File file = new File(filename);
                    File file2 = new File(URLDecoder.decode(filename));
                    if (!file.exists() && !file2.exists()) continue;
                    return TomcatClassPath.targetURL(currentUrl, fixedResName);
                }
                URL resourceURL = TomcatClassPath.targetURL(currentUrl, resourceName);
                URLConnection urlConnection = resourceURL.openConnection();
                try {
                    urlConnection.getInputStream().close();
                }
                catch (SecurityException e) {
                    return null;
                }
                if (!resourceURL.getProtocol().equals("http")) {
                    return resourceURL;
                }
                int code = ((HttpURLConnection)urlConnection).getResponseCode();
                if (code < 200 || code >= 300) continue;
                return resourceURL;
            }
            catch (MalformedURLException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL targetURL(URL base, String name) throws MalformedURLException {
        StringBuffer sb = new StringBuffer(base.getFile().length() + name.length());
        sb.append(base.getFile());
        sb.append(name);
        String file = sb.toString();
        return new URL(base.getProtocol(), base.getHost(), base.getPort(), file, null);
    }
}

